this.name		= "nullgate";
this.author		= "Switeck";
this.copyright	= "ideas and models copied from Gates OXP ...and elsewhere!";
this.licence		= "Creative Commons Attribution - Non-Commercial - Share Alike 3.0";
this.description= "Null Gates - frankenstein script!";
this.version		= "0.8.87 - for Oolite 1.80 and later, circa 2023";

"use strict";

this.startUp = function()
{
	worldScripts['nullgate'].logging = true; // was true/false!  ...I would use just this.logging, but the game treats that as undefined too often!
	$ngDefendTimer = clock.absoluteSeconds;
	this.firstLaunch = true;
	$ngJump_Array = [-9];
	$ngCounter = -9;
	this.nullgateJustran = 0;
//	missionVariables.$ng = null;
	$ngAngry = 0;
//	if(missionVariables.nullgate) {
//		missionVariables.$ng = missionVariables.nullgate;
//		missionVariables.nullgate = null;
//	}
//	if(!$nullgate) $nullgate = 0;
//	else if(worldScripts['nullgate'].logging) log(this.name,"worldScripts['nullgate'].nullgate is not null!");
}

//this.shipLaunchedFromStation
this.shipWillLaunchFromStation = function ()
{
	$ngJump_Array = [-8];
	$ngCounter = -8;
	if(worldScripts['nullgate'].logging) log(this.name,$ngCounter,"just launched!");	// ADDED FOR TESTING!
	if(this.firstLaunch) this.$tryAddingNullgate();
};

// These reset the counters -- KILLING the jumpPath if the player does a manual hyperspace jump, docks, or somehow ends up in the "wrong" system!

this.playerStartedJumpCountdown = this.playerCancelledJumpCountdown = function(jump)
{
	$ngJump_Array = [-7];
	$ngCounter = -7;
}

this.playerEnteredNewGalaxy = function(galaxyNumber) 
{
	if(missionVariables.$ng < 2) missionVariables.$ng = null;	// If you never started Null Gates campaigns, remove this mission variable!
}

this.playerWillEnterWitchspace = this.shipDied = function(jump)
{
	if(this.scanTimer) this.scanTimer.stop();
	if(this.npcTimer) this.npcTimer.stop();
}

//this.shipWillExitWitchspace = function()
this.shipExitedWitchspace = function(jump)
{
	this.firstLaunch = true;
	this.nullgateJustran = 0;
	$nullgate = null;
	if(system.ID > -1) this.$tryAddingNullgate();
	if($ngCounter >0) this.$ngJumping()
//	if($ngCounter <0 && system.ID > -1) this.$tryAddingNullgate();

// Represents the jump-route of the supermassive wormhole found at the Thargoid Beehive in the middle of the big void to reach Ditere in Galaxy Chart 3:
//	if(galaxyNumber == 2) if(missionVariables.$ng  >1000 && $ngCounter <0 && player.ship.galaxyCoordinates.x >= 39 && player.ship.galaxyCoordinates.x < 39.3 && player.ship.galaxyCoordinates.y >= 42 && player.ship.galaxyCoordinates.y < 42.7) {
	else if(galaxyNumber == 2) if(missionVariables.$ng  >1 && $ngCounter <0 && swiJumpCount <0 && player.ship.galaxyCoordinates.x > 39 && player.ship.galaxyCoordinates.x < 39.6 && player.ship.galaxyCoordinates.y > 42 && player.ship.galaxyCoordinates.y < 42.9) {
//		$ngJump_Array = [50186,50040,50232,50040,50232,50040,50184,50186,50184,50232,50184,50232,40184,133];
		$ngJump_Array = [186];
		for(var i3=0; i3< 2; i3++) this.choice(Math.floor(68+Math.random()*3));
		this.choice(Math.floor(24+Math.random()*4));
		for(var i3=0; i3< 2; i3++) this.choice(Math.floor(71+Math.random()*3));
		this.choice(Math.floor(44+Math.random()*14));
		if($ngJump_Array[0] > -2) $ngJump_Array.push("-8");
		$ngHop = system.ID;
		$ngLast = $ngHop;
		$ngPast = $ngHop;
		$ngCounter = 1;
		ngStartTime = clock.seconds;
		missionVariables.$ng = 7979;
		this.$ngJumping();
	} else if(missionVariables.$ng  >1 && $ngCounter <0 && swiJumpCount <0 && player.ship.galaxyCoordinates.x > 44.3 && player.ship.galaxyCoordinates.x < 44.7 && player.ship.galaxyCoordinates.y > 60 && player.ship.galaxyCoordinates.y < 60.2) {
//	} else if(missionVariables.$ng  >1000 && $ngCounter <0 && player.ship.galaxyCoordinates.x >= 44.3 && player.ship.galaxyCoordinates.x < 44.7 && player.ship.galaxyCoordinates.y >= 60 && player.ship.galaxyCoordinates.y < 60.2) {
//		$ngJump_Array = [50040,50186,50040,50232,50040,50232,50040,50184,50186,50184,50232,50184,50232,40184,133,129,161];
//		$ngJump_Array = [50040,50186,50040,50232,50040,50232,50040,50232,50040,50184,50186,50184,50232,50184,50232,40184,133];
//		$ngJump_Array = [50040,50186,50040,50186,50040,50232,50040,50232,50040,50232,50040,50184,50186,50184,50232,50184,50232,50184,50232,40184,133];
		$ngJump_Array = [186,50040,50186,50040,25184,35232,50184,50232,40184,133];
/*		$ngJump_Array = [40,50186];
		for(var i3=0; i3< 2; i3++) this.choice(Math.floor(68+Math.random()*3));
		this.choice(Math.floor(24+Math.random()*4));
		for(var i3=0; i3< 2; i3++) this.choice(Math.floor(71+Math.random()*3));
		this.choice(Math.floor(44+Math.random()*14));
*/
		if($ngJump_Array[0] > -2) $ngJump_Array.push("-8");
		$ngHop = system.ID;
		$ngLast = $ngHop;
		$ngPast = $ngHop;
		$ngCounter = 1;
		ngStartTime = clock.seconds;
		missionVariables.$ng = 7979;
		this.$ngJumping();
	}

};
/*
this.$wormhole_jump = function()
{
	if(galaxyNumber == 2) if($ngCounter <0 && player.ship.galaxyCoordinates.x > 39 && player.ship.galaxyCoordinates.x < 39.6 && player.ship.galaxyCoordinates.y > 42 && player.ship.galaxyCoordinates.y < 42.9) {
//	if($ngCounter <0 && swiJumpCount <0 && owt2o_counter <0 && worldScripts['murphy-thargoid-drive'].jumpArray === null && player.ship.galaxyCoordinates.x > 39 && player.ship.galaxyCoordinates.x < 39.6 && player.ship.galaxyCoordinates.y > 42 && player.ship.galaxyCoordinates.y < 42.9) {
// Top route to Ditere!
			$ngJump_Array = [50186,50040,50232,50040,50232,50040,50184,50186,50184,50232,50184,50232,40184,133,-8];
			$ngCounter = 0;
			$ngHop = system.ID;
			$ngPast = system.ID;
//			$ngLast = player.ship.targetSystem;
			ngStartTime = clock.seconds;
			player.commsMessage("Continuing down the Supermassive Wormhole's path! (186 route)",6);
//			worldScripts['nullgate'].$wormhole_jump();
			return;

		} else if($ngCounter <0 && player.ship.galaxyCoordinates.x > 44.3 && player.ship.galaxyCoordinates.x < 44.7 && player.ship.galaxyCoordinates.y > 60 && player.ship.galaxyCoordinates.y < 60.2) {
// Bottom route to Ditere!
//			$ngJump_Array = [50186,50040,50186,50040,50232,50040,50232,50040,50232,50040,50184,50186,50184,50232,50184,50232,50184,50232,40184,133];
//			$ngJump_Array = [50186,50040,50186,50040,50232,50040,50232,50040,50232,50040,50184,50186,50184,50232,50184,50232,40184,133];
//			$ngJump_Array = [50040,50186,50040,50232,50040,50232,50040,50232,50040,50184,50186,50184,50232,50184,50232,40184,133];
//			$ngJump_Array = [50040,50186,50040,50232,50040,50232,50040,50184,50186,50184,50232,50184,50232,40184,133];
//			$ngJump_Array = [50186,50040,50186,50040,50232,50040,50232,50040,50184,50186,50184,50232,50184,50232,40184,133];
//			$ngJump_Array = [50186,50040,50232,50040,50232,50040,50232,50040,50184,50186,50184,50232,50184,50232,40184,133];
//			$ngJump_Array = [50186,50040,50232,50040,50232,50040,50184,50186,50184,50232,50184,50232,45184,133];
//			$ngJump_Array = [50186,50040,50232,50040,50232,50040,50184,50186,50184,50232,50184,50232,40184,133];
//			$ngJump_Array = [50186,75040,25184,25186,25184,40232,50184,50232,40184,133];
			$ngJump_Array = [50040,50186,50040,25184,35232,50184,50232,40184,133];
//			$ngJump_Array = [50186,50040,50232,50040,25184,35232,50184,50232,40184,133];
// puts a -8 value on the end to mark the end of jump Path chain!
			if($ngJump_Array[0] > -2) $ngJump_Array.push("-8");
			$ngCounter = 0;
			$ngHop = system.ID;
			$ngPast = system.ID;
//			$ngLast = player.ship.targetSystem;
//			ngStartTime = clock.seconds;
			ngStartTime = clock.adjustedSeconds;
			player.commsMessage("Continuing down the Supermassive Wormhole's path! (40 route)",6);
			missionVariables.$ng = 7979;
//			worldScripts['nullgate'].$ng_jump();
			return;
		}
}
*/
this.$tryAddingNullgate = function()
{
//	if(worldScripts['nullgate'].logging) log(this.name,$ngCounter,this.firstLaunch,system.isInterstellarSpace,system.countShipsWithRole("nullgate"),galaxyNumber,"...attempting to add Null Gate!");	// ADDED FOR TESTING!
	if(worldScripts['nullgate'].logging) log(this.name,"...attempting to add Null Gate!");	// ADDED FOR TESTING!

	$ngDefendTimer = clock.absoluteSeconds; // moved from this.startUp  No use counting if there's nothing to attack it?
//	if(!system.sun || !this.firstLaunch) return;
//	if(system.sun && this.firstLaunch && system.countShipsWithRole("nullgate") <1) {
	if(!system.isInterstellarSpace && this.firstLaunch && system.countShipsWithRole("nullgate") <1) {
		this.ng_locations =[256];
// NEED to decide which systems to place a Null Gate in! Galaxy 3 in a few places? Tier 13/14/15 worlds especially?
// galaxyNumber starts at 0 = galaxy 1, so 7 = galaxy 8
// the system.ID number should be: 121 = Aatedire  ...but 9 may not be Leater!
//	if(!system.isInterstellarSpace && !system.sun.hasGoneNova && galaxyNumber == 7 && (system.ID == 121 || system.ID == 9))

// Sadly, reusing $ngJump_Array variable here will cause all kinds of conflicts -- the player could be in the middle of a jump-chain when this "hits"!
	$nullgate = null;

// Locations of Null Gates in Galaxy Charts 1-8
//	if(galaxyNumber == 0) this.ng_locations =[1019,23,33,1058,151,1159,1174,1182,1207,1211,1237,1238,246,250]; // 151 = TL 15!  23,33,246,250 = TL 14
	if(galaxyNumber == 0) this.ng_locations =[1019,23,33,1058,151,153,158,1159,168,1174,1182,1207,210,1211,232,1237,1238,246,250]; // 151 = TL 15!  23,33,246,250 = TL 14	153,158,168,210,232 = TL 13
	if(galaxyNumber == 1) this.ng_locations =[1000,1015,1029,39,1043,1046,66,1085,1087,1090,98,1121,1122,1125,1136,1138,1139,1147,1158,1168,1172,1175,1176,1183,1216,231,1234,1248,1254]; // 39 = TL 15!  66,98,231 = TL 14	172 TL=11 added to cross rift

	if(galaxyNumber == 2) {
		this.ng_locations =[5,6,10,17,22,34,36,38,42,54,1062,63,69,1070,79,81,1090,1118,1129,145,1148,155,1159,1170,1181,1182,219,1235,1246,1255]; // so only 62,70,90,118,148,159,170,181,182,235,246,255 are hostile Derelict Null Gates!
//		this.ng_locations =[5,6,10,22,36,38,42,54,1062,63,69,1070,79,1090,1118,1148,1159,1170,1181,1182,1235,1246,1255]; // so only 62,70,90,118,148,159,170,181,182,235,246,255 are hostile Derelict Null Gates!
// While the Null Gate is "down" at Teedus (id=54), replace it with a hostile Null Gate. This gets cleared up once you've visited a couple high-tech Null Gate systems.
		if(missionVariables.$ng && missionVariables.$ng < 2 && system.ID == 54) {
			this.ng_locations[9]=1054;
//		} else if(missionVariables.$ng > 4948 && system.ID ==118) {	// Also done by later changes!
//			this.ng_locations[17]=118;
		} else if((missionVariables.$ng < 10 || missionVariables.$ng > 45) && (system.ID == 54 || system.ID ==118) && Math.random() < 0.4) {
			system.addShipsToRoute("anaconda-exion", 1, Math.random()*0.7, "wp");
			if(worldScripts['nullgate'].logging) log(this.name,"Anaconda - Exion Valdiaz added to system id 54 or 118!");
		}
//	"Thargoid attacks have been reported on the rise in-and-around Istimale."
// If distance-to-Istimale (ID=93) is less than 9 LY and NOT in interstellar space and a slowly-increasing random chance...then you end up with your next hyperspace jump being set as a misjump!
		if(!system.isInterstellarSpace && System.infoForSystem(galaxyNumber, system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,93)) <9 && (missionVariables.thargplans || missionVariables.$ng>48) && Math.random() < 0.1) {
			player.ship.scriptedMisjump = 1;
			if(worldScripts['nullgate'].logging) log(this.name,"Next jump is a misjump!");
//			if(player.score > 999 && Math.random() < 0.10) {
			if(Math.log(player.score+1)-5 > Math.random() *50) {
				system.addGroupToRoute("thargoid", Math.ceil(Math.log(player.score+1)), Math.random()*0.7, "wp");
//				system.addGroupToRoute("thargoid", 9, 0.7, "wp");
				if(worldScripts['nullgate'].logging) log(this.name,"Thargoid swarm in system!");
			}
		}

//	"Thargoid attacks have been reported at Raerqu -- system 182."
// Thargoid Swarm spotted at Raerqu (ID=182)!
//		if(!system.isInterstellarSpace && system.ID == 182 && (missionVariables.thargplans || missionVariables.$ng>200) && missionVariables.$ng<400 && Math.random() < 0.10) {
//		if(system.ID == 182 && (missionVariables.thargplans || missionVariables.$ng>45) && missionVariables.$ng<89 && Math.random() < 0.10) {
		if(system.ID == 182) {
			system.addShipsToRoute("WhitefishBay", 1, 0.5, "wp");
			if(missionVariables.$ng>5 && missionVariables.$ng<50 && Math.random() < 0.3) system.addShipsToRoute("boa-eds-mooned", 1, Math.random()*0.7, "wp");
			if((missionVariables.thargplans || missionVariables.$ng>45) && missionVariables.$ng<89 && Math.random() < 0.3) {
				system.addGroupToRoute("thargoid", Math.ceil(Math.log(player.score+1)), Math.random()*0.7, "wp");
//				system.addGroupToRoute("thargoid", 9, 0.7, "wp");
				if(worldScripts['nullgate'].logging) log(this.name,"Thargoid swarm in system!");
//			if(missionVariables.$ng >85 && missionVariables.$ng<90) missionVariables.$ng += 10; // Need to change this so only happens *IF* you kill the Thargoid swarm!
			}
		}
	}

	if(galaxyNumber == 3) this.ng_locations =[1000,1008,1023,1024,1040,1057,1062,1064,1088,1110,1126,1128,1136,141,1152,1168,1175,1185,1190,1192,197,1199,1216,1219,1220,1238,1251,1254];	// 141,197 = TL 14
	if(galaxyNumber == 4) this.ng_locations =[1011,39,70,1081,1092,1098,99,1106,1118,1123,126,1143,1160,1187,1190,198,1203,1211,1238,249,1254]; // 198 = TL 15! 39,70,99,126,249 = TL 14
//	if(galaxyNumber == 5) this.ng_locations =[1006,1010,1021,1032,1040,1050,1080,1086,1131,1134,1144,1149,1151,1156,1158,1178,1204,1212,1218,1226,1255]; // 149 = TL15!  6,40,50,114,204 = TL14!  10,21,32,80,86,131,134,151,156,158,178,212,218,226,255 = all Lobster worlds
	if(galaxyNumber == 5) this.ng_locations =[6,1010,1021,1032,40,50,1080,1086,1131,1134,144,149,1151,1156,1158,1178,204,1212,1218,1226,1255]; // 149 = TL15!  6,40,50,114,204 = TL14!  10,21,32,80,86,131,134,151,156,158,178,212,218,226,255 = all Lobster worlds
	if(galaxyNumber == 6) this.ng_locations =[1002,6,53,1057,66,71,1074,1083,87,88,1089,103,1114,119,1127,1135,1163,1164,1180,184,1190,1201,1211,1220,1224,1227,229,1230,1247]; // 53,66 = TL 15!  6,71,87,103,119,184,229 = TL 14
//	if(galaxyNumber == 6) this.ng_locations =[1002,6,53,66,71,87,88,1089,103,119,1135,184,1224,229,1247]; // 53,66 = TL 15!  6,71,87,103,119,184,229 = TL 14
//	if(galaxyNumber == 7) this.ng_locations =[41,1044,82,1085,1093,1115,1137,1147,1155,244,251]; // Gateway worlds to Oresrati added...137 (human TL13) and/or 147 (lizard TL13) semi-close to it.
	if(galaxyNumber == 7) this.ng_locations =[2,7,1016,1033,34,1039,1040,41,1042,1044,1059,82,83,1085,1093,1095,1115,1122,125,137,145,147,1152,1153,1155,1163,1176,180,1183,1185,187,188,1190,194,1196,200,1212,218,1222,226,1229,1240,241,244]; // Gateway worlds to Oresrati added...137 (human TL13) and/or 147 (lizard TL13) semi-close to it.
//	if(galaxyNumber == 7) this.ng_locations =[41,1044,82,1085,1093,1115,1155,244,251]; // No direct gateway worlds to Oresrati.
//  ALL Null Gates in Galaxy Chart 6 are derelicts!

// THIS will need to be removed after testing is over!
//	if(galaxyNumber != 2) missionVariables.$ng = null;

//	if(worldScripts['nullgate'].logging) log(this.name,missionVariables.$ng,system.ID,this.ng_locations);
	var x =0;
	while(x < this.ng_locations.length) {
//		var i = parseInt(this.ng_locations[x]) - Math.floor(parseInt(this.ng_locations[x])/1000)*1000;
		var y = parseInt(this.ng_locations[x]);
		var i = y - Math.floor(y/1000)*1000;
/*
		if(y>999) {
			mission.markSystem(i); // COMMENT-OUT THIS LINE if you don't want Null Gate locations shown!
		} else {
			mission.markSystem({system: i, name: "Null Gate", markerColor: "greenColor", markerScale: 1.0, markerShape: "MARKER_DIAMOND"}); // COMMENT-OUT THIS LINE if you don't want Null Gate locations shown!
//		markerShape : A string describing the shape of the marker. Valid values are MARKER_X, MARKER_PLUS, MARKER_SQUARE and MARKER_DIAMOND. If this value is invalid or omitted, MARKER_X will be used.
		}
*/
//		if(worldScripts['nullgate'].logging) log(this.name,x,y,i);
		x++;
		if(system.ID == i ) { // place the nullgate!
			// Choose TYPE of Null Gate present! May change if system is "conquered" by Thargoids during various missions?
			// I also want inactive Null Gates to come online over time, starting at high TL and working down...
			if((y>999 && (missionVariables.$ng < 405 || system.techLevel <(14 - Math.log(missionVariables.$ng+player.score+2))) || system.government <3) || (galaxyNumber == 2 && ((missionVariables.$ng < 2 && (system.ID == 42 || system.ID == 54)) || (missionVariables.$ng < 5 && system.ID != 42 && system.ID != 54)))) {	// Null Gates are only inactive early on in campaign/missions.
//			if((y>999 && player.score < 2000 && missionVariables.$ng < 905) || (missionVariables.$ng < 2 && galaxyNumber == 2 && (system.ID == 54 ||  && system.ID == 42)) || missionVariables.$ng < 5) {	// Null Gates are only inactive early on in campaign/missions.
//			if(y>99999) {	// Only add friendly gates for TESTING!
				// DERELICT/HOSTILE Null Gate!
//				nullgate = system.addShips("nullgate2", 1, Vector3D(Math.random()*0.4-0.2, Math.random()*0.4-0.2, Math.random()*0.3+0.3).fromCoordinateSystem("spu"))[0]; // z-distance from star was 0.2-0.6 but now 0.3-0.6
//				$nullgate = system.addShips("nullgate2", 1, Vector3D(Math.random()*0.4-0.2, Math.random()*0.4-0.2, Math.random()*0.3+0.3).fromCoordinateSystem("spu"))[0]; // z-distance from star was 0.2-0.6 but now 0.3-0.6
//				$nullgate = system.addShips("nullgate2", 1, Vector3D(Math.random()*0.4-0.2, Math.random()*0.4-0.2, Math.random()*0.6-1).fromCoordinateSystem("spu"))[0]; // z-distance from star now MINUS 0.4-1  Math.random()*0.6-1
				$nullgate = system.addShips("nullgate2", 1, Vector3D(Math.random()*0.4-0.2, Math.random()*0.4-0.2, Math.random()-1.4).fromCoordinateSystem("spu"))[0]; // z-distance from star now MINUS 0.4-1.4
				if(Math.random() < 0.10 && (missionVariables.thargplans === "MISSION_COMPLETE" || missionVariables.thargplans === "PRELUDE" || missionVariables.thargplans === "RUNNING" || missionVariables.reserve_duty === "SYSTEM_INVASION2" || missionVariables.reserve_duty === "SYSTEM_INVASION" || missionVariables.reserve_duty === "FLEET_INTERCEPT" || missionVariables.$ng>300) ) {
// Null Gate should ALWAYS be in "angry hour" if Thargoid Plans mission is active!
// HAVE to activate the timer script so Thargoids pour out till it's empty.
// Can also toss it in if other Thargoid-related missions are active. :)
// Now goes active is Galactic Navy is experiencing Thargoid invasions in a system.
					$ngAngry = 100;
//					this.shipBeingAttacked(); // added to trigger Thargoid swarms out of Null Gate!
					this.$ngUnderAttack(); // added to trigger Thargoid swarms out of Null Gate!
//				if(this.$ngcheckTimer2) this.$ngcheckTimer2.start()
//				else this.$ngcheckTimer2 = new Timer(this, this.$ngInvasion, 5, 5);
				} else {
					// turn LIGHTS_OFF !
//					nullgate.sendAIMessage("LIGHTS_OFF");
					$nullgate.lightsActive = false;
					$ngAngry = 0; // Odds of a Thargoid attack out of the gate starts at 0% and increases with each hit.
				}
			} else {
			// "Station"/Friendly Null Gate!
//		nullgate = system.addShipsToRoute("nullgate", 1, 0); // right near the witchpoint buoy
//		nullgate = system.addShips("nullgate", 1, system.mainStation.position.add(Vector3D(8000, 8000, 0).fromCoordinateSystem("abs"))); // VERY near main station!
//				nullgate = system.addShips("nullgate", 1, Vector3D(Math.random()*0.4-0.2, Math.random()*0.4-0.2, Math.random()*0.3+0.3).fromCoordinateSystem("spu"))[0]; // z-distance from star was 0.2-0.6 but now 0.3-0.6
//				$nullgate = system.addShips("nullgate", 1, Vector3D(Math.random()*0.4-0.2, Math.random()*0.4-0.2, Math.random()*0.5-1).fromCoordinateSystem("spu"))[0]; // z-distance from star was 0.2-0.6 but now MINUS 0.5-1
				$nullgate = system.addShips("nullgate", 1, Vector3D(Math.random()*0.4-0.2, Math.random()*0.4-0.2, Math.random()*0.3+0.3).fromCoordinateSystem("spu"))[0]; // z-distance from star was 0.2-0.6 but now 0.3-0.6
				$ngAngry = Math.floor(-100); // nearly impossible to induce a Thargoid attack out of a working Null Gate by shooting it. Have to shoot it >100 times.
				if(worldScripts['nullgate'].logging) log(this.name,"Friendly Null Gate added! $ngAngry = "+$ngAngry);
				// turn LIGHTS_ON ! (actually do nothing, since lights start on!)
				//nullgate.sendAIMessage("LIGHTS_ON");
				$nullgate.lightsActive = true;
			}
//			if(worldScripts['nullgate'].logging) log(this.name,x,y,i,nullgate);
			x = this.ng_locations.length +1; // to quickly end while loop!
// FROM ship.spawned section
//			if($nullgate != null) {
//				this.ship.scannerDisplayColor1 = "greenColor";
//				this.ship.scannerDisplayColor2 = "whiteColor";
//				$ngTotalDefenders = 15; // max number of Thargoid "defenders" that can be launched overall by the gate if attacked...maybe instead of a fixed number have it increase or decrease based on how many kills you have and how much you research Null Gates backgrounds?
				$ngTotalDefenders = Math.ceil(Math.log(3*missionVariables.$ng+player.score+1)); // max number of Thargoid "defenders" that can be launched overall by the gate if attacked...increases based on how many kills you have and how much you research Null Gates backgrounds!
				$ngDefendTimer = clock.absoluteSeconds;
				if(this.scanTimer) this.scanTimer.start()
				else this.scanTimer = new Timer(this, this.shipApproach, 0, 1.0); // scan for jumping ships every 1 second - too long/short?
				if(this.npcTimer) this.npcTimer.start()
				else this.npcTimer = new Timer(this, this.$npcTraders, 0, 180); // scan for NPC traders who may want to use the gates every 3 minutes
//			}
// end of ship.spawned section
		}
	}

// Deletes done to only run this once!
//	delete this.shipWillLaunchFromStation;
//	delete this.shipExitedWitchspace;

	}
	this.firstLaunch = false; // added here to avoid later returns!
//	$ngAngry = 0;
//	if($ngCounter >0) this.$ngJumping();
}

/*
// This (or something like it) might evenutally get used if a badly damaged (working?) Null Gate attempts to save itself by hyperspacing out.
this.shipexitSystem = function()
{
	player.commsMessage("Null Gate Jumping OUT!");
//	if(!system.isInterstellarSpace && player.ship.targetSystem === system.ID) this.nullgate.exitSystem()
//	else this.nullgate.exitSystem(player.ship.targetSystem);
// Put more complex scripting here, such as the multi-jump route to get to Oresrati from Arustea.
}
*/

nullgates_clients = function(entity)
{
//if (!nullgate){return false;}
if ($nullgate) {
//return (entity.isShip && entity.primaryRole != "nullgates_gateGuard" && !entity.isWeapon && !entity.isRock && !entity.isCargo && (!entity.hasOwnProperty("nullgates_receivingGate")|| entity.nullgates_receivingGate == null)); // ships that can use jumpgates (exclude spawned defenders, missiles, mines, asteroids and cargo pods
return (entity.isShip && entity.primaryRole != "nullgates_gateGuard" && !entity.isWeapon && !entity.isRock && !entity.isCargo && !entity.hasOwnProperty("nullgates_receivingGate") ); // ships that can use jumpgates (exclude spawned defenders, missiles, mines, asteroids, and cargo pods ...and nullgates_gateGuard
} else {return false;}
}

nullgates_oldClients = function(entity)
{
if ($nullgate) {
//return (entity.isShip && entity.hasOwnProperty("nullgates_receivingGate") && entity.nullgates_receivingGate != null && entity.position.distanceTo(this.ship.position) > 500 && entity.position.distanceTo(this.ship.position) < 5000); // ships which have come through this gate and are now between 500m and 5km from it
return (entity.isShip && entity.hasOwnProperty("nullgates_receivingGate") && entity.nullgates_receivingGate != null && entity.position.distanceTo($nullgate.position) > 500 && entity.position.distanceTo($nullgate.position) < 5000); // ships which have come through this gate and are now between 500m and 5km from it
} else {return false;}
}

nullgates_outboundNPCs = function(entity)
{
if ($nullgate) {
return (entity.isShip &&  entity.AI == "exitingTraderAI.plist" && entity.AIState == "HEAD_AWAY_FROM_PLANET"  && entity.position.distanceTo($nullgate.position) < 300000);
} else {return false;}
}

nullgates_inboundNPCs = function(entity)
{
if ($nullgate) {
	return (entity.isShip &&  entity.AI == "route2sunskimAI.plist" && entity.AIState == "HEAD_FOR_SUN"  && entity.position.distanceTo($nullgate.position) < 300000);
} else {return false;}
}
/*
// Runs every time a new ship is added instead of ONLY when a Null Gate is added!
this.shipSpawned = function()
{
	if($nullgate != null) {
//	if(this.ship != null) {
//		this.ship.scannerDisplayColor1 = "greenColor";
//		this.ship.scannerDisplayColor2 = "whiteColor";
//		this.nullGateOnline = true;
//		this.ship.orientation = system.mainStation.orientation; // point them all in the same direction, along universal Z.
		$ngTotalDefenders = 15; // max number of defenders that can be launched overall by the gate if attacked
		$ngDefendTimer = clock.absoluteSeconds;
//	}
//	if(worldScripts['nullgate'].logging) log(this.name,$ngTotalDefenders);
	if(this.scanTimer) this.scanTimer.start()
	else this.scanTimer = new Timer(this, this.shipApproach, 0, 1.0); // scan for jumping ships every 1 second - too long/short?
	if(this.npcTimer) this.npcTimer.start()
	else this.npcTimer = new Timer(this, this.$npcTraders, 0, 180); // scan for NPC traders who may want to use the gates every 3 minutes
	}
}
*/

this.shipApproach = function()
{
	if(!player.ship || !player.ship.isValid) {
		this.shipDied();
		return;
	}

//	if(worldScripts['nullgate'].logging) log(this.name,"1 Checking Nullgate Status: "+$nullgate.displayName+" lights ON?: "+$nullgate.lightsActive);
//	if(this.ship != null) { // Added to prevent undefined results!
	if($nullgate) { // Added to prevent undefined results!
//	var $ngPastClients = system.filteredEntities(this, nullgates_oldClients, this.ship, 5000); // if any old clients are around, strip their client status
	var $ngPastClients = system.filteredEntities(this, nullgates_oldClients, $nullgate, 5000); // if any old clients are around, strip their client status
	if($ngPastClients.length > 0) {
		for(var ngi = 0; ngi < $ngPastClients.length; ngi++)
		{
			$ngPastClients[ngi].nullgates_receivingGate = null;
			if($ngPastClients[ngi].isPlayer) player.consoleMessage("Jump gate cleared.", 6);
		}
	}

//	if(worldScripts['nullgate'].logging) log(this.name,"2 Checking Nullgate Status: "+$nullgate.displayName+" lights ON?: "+$nullgate.lightsActive);
//	var ng_waitingline = system.filteredEntities(this, nullgates_clients, this.ship, 250); // if there is no-one wanting to jump, end the test
	var ng_waitingline = system.filteredEntities(this, nullgates_clients, $nullgate, 250); // if there is no-one wanting to jump, end the test
	if(ng_waitingline.length == 0 || $nullgate.lightsActive != true) return;

//	this.nullGateOnline = true;

	if(ng_waitingline[0].hasOwnProperty("nullgates_receivingGate") && ng_waitingline[0].nullgates_receivingGate == this.ship) return; // if the jumper has just arrived, end the test

	if(worldScripts['nullgate'].logging) log(this.name,"3 Checking Nullgate Status: "+$nullgate.displayName+" lights ON?: "+$nullgate.lightsActive);
	if(ng_waitingline[0].AI == "nullgates_useGateAI.plist") {
		ng_waitingline[0].reactToAIMessage("JUMPED");
//		ng_waitingline[0].position = [-1000000-Math.random()*1000000, -1000000-Math.random()*1000000, -1000000-Math.random()*1000000];
		ng_waitingline[0].position = [-9E6*(1+Math.random()),-9E6*(1+Math.random()),-9E6*(1+Math.random())];
		this.ngship1 = system.addShips("alloy", 1, ng_waitingline[0].position.add(ng_waitingline[0].heading.multiply(150)), 0)[0]; // was distance 150, then 130
		this.ngship1.switchAI("missileAI.plist");
		this.ngship1.AIState ="EXPLODE";
		this.ngship1.fuel = 7;
		this.ngship1.exitSystem();
		this.ngship1.remove(true);
		return;
	}
//	if(worldScripts['nullgate'].logging) log(this.name,ng_waitingline,nullgate);
	if(ng_waitingline[0].isPlayer && $nullgate && $nullgate.lightsActive == true) {
// Need to put in a check whether the player is attempting to use a working Null Gate or Derelict Null Gate. BOTH allow jumps, but only one charges credits.
// do a check for this.nullgate ...one of its sub-properties should certainly reveal whether working NG or Derelict NG.
		if(worldScripts['nullgate'].logging) log(this.name,"4 Checking Nullgate Status: "+$nullgate.displayName+" lights ON?: "+$nullgate.lightsActive);
		if($nullgate.displayName == "Null Gate") { // name = "Null Gate" doesn't work!		$nullgate.position.distanceTo(player.ship) < 260
//		if(this.nullgate.position.distanceTo(player.ship) < 260) {
//		if(system.shipsWithRole("nullgate", player.ship, 260).length > 0 || system.shipsWithRole("nullgate2", player.ship, 260).length > 0) {
		// system.shipsWithRole("station", player.ship, 150E3).length < 1 && system.shipsWithRole("station", player.ship, 1500E3).length > 0

// $nullgate.lightsActive == true    <- will need to be true to let you travel through the gate.
// worldScripts["nullgate"].name == "Null Gate";
		if(missionVariables.$ng < 7) {	// Depends on the Null Gate whether this should work!
		if(player.credits < 250) {
			player.consoleMessage("Insufficient credits to perform jump.", 6);
			return;
		} else {
			if(worldScripts['nullgate'].logging) log(this.name,$nullgate.displayName,$nullgate.lightsActive,"Jump gate activated. 250 credits paid.");
			player.consoleMessage("Jump gate activated. 250 credits paid.", 6);
			player.credits -=250; // 250 credits for a jump is pretty steep, effectively game-balanced right there.
		}
		} else if(player.credits < 100) {
			player.consoleMessage("Insufficient credits to perform jump.", 6);
			return;
		} else {
			if(worldScripts['nullgate'].logging) log(this.name,$nullgate.displayName,$nullgate.lightsActive,"Jump gate activated. 100 credits paid.");
			player.consoleMessage("Jump gate activated. 100 credits paid.", 6);
			player.credits -=100; // 100 credits for a jump is more reasonable, but after the BAD news scares...probably won't be used much!
		}
//		} else return;
		} else if($nullgate.displayName != "Derelict Null Gate") return;

// initial variable settings in preparation of jumping!
			$ngHop = system.ID;
			$ngPast = $ngHop;
			$ngLast = player.ship.targetSystem;
			$ngDis = System.infoForSystem(galaxyNumber, $ngHop).distanceToSystem(System.infoForSystem(galaxyNumber,$ngLast)); // raw straightline distance works even if $ngLast system unreachable from $ngHop system.
			$ngJump_Array = [-5];
			$ngCounter = 1;

// Galaxy Chart shortcut tables!
	if(galaxyNumber == 0 && missionVariables.$ng >470) {
// First IF checks that the routeToSystem path EXISTS, so interstellar space doesn't "trip it up".
/*
		if($ngHop != 209 && $ngLast == 143 && System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber, 143),"OPTIMIZED_BY_TIME") ) {
			if(System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,47), "OPTIMIZED_BY_TIME").distance < System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,143), "OPTIMIZED_BY_TIME").distance) {
				$ngJump_Array = System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,47), "OPTIMIZED_BY_TIME").route.concat([75209, 143]);
			}
		}
		if($ngHop != 209 && $ngLast ==  47 && System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber, 47),"OPTIMIZED_BY_TIME") ) {
			if(System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,143), "OPTIMIZED_BY_TIME").distance < System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,47), "OPTIMIZED_BY_TIME").distance) {
				$ngJump_Array = System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,143), "OPTIMIZED_BY_TIME").route.concat([50209,  47]);
			}
		}
		if($ngHop != 223 && $ngLast == 238 && System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber, 238),"OPTIMIZED_BY_TIME") ) {
			if(System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,213), "OPTIMIZED_BY_TIME").distance < System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,238), "OPTIMIZED_BY_TIME").distance) {
				$ngJump_Array = System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,213), "OPTIMIZED_BY_TIME").route.concat([50223, 238]);
			}
		}
		if($ngHop != 223 && $ngLast == 213 && System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber, 213),"OPTIMIZED_BY_TIME") ) {
			if(System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,238), "OPTIMIZED_BY_TIME").distance < System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,213), "OPTIMIZED_BY_TIME").distance) {
				$ngJump_Array = System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,238), "OPTIMIZED_BY_TIME").route.concat([75223, 213]);
			}
		}
*/
//		if($ngLast == $ngHop) {
		if($ngHop ==  47 || $ngLast == 143) $ngJump_Array = [  47,50209, 143]; // 47/143 sharp angle jump pair.
		if($ngHop == 143 || $ngLast ==  47 && $ngHop !=  47) $ngJump_Array = [ 143,50209,  47];
		if($ngHop ==  74 || $ngLast == 247) $ngJump_Array = [74,30194,247];	// 62.24 hours 74<->194 -> 247 way out of the bottom middle.
		if($ngHop == 194 || $ngLast == 247 && $ngHop !=  74) $ngJump_Array = [194,9074,247];	// 46.35 hours
		if($ngHop == 213 || $ngLast == 238) $ngJump_Array = [ 213,50223, 238]; // 213/238 sharp angle jump pair.
		if($ngHop == 238 || $ngLast == 213 && $ngHop != 213) $ngJump_Array = [ 238,75223, 213];
		if($ngHop == 238 && $ngLast == 160) $ngJump_Array = [238,10223,26213,25015,55213,30059,160];	// 154.7 hours
		if($ngHop == 238 && $ngLast == 238) $ngJump_Array = [238,10223,26213,25015,55213,30059,99160,99208,69];	// 242.81 hours (adds a 1% misjump on the end to make the route quicker game-clock time-wise.)
		if($ngHop == 182 && $ngLast ==   69) $ngJump_Array = [238,10223,26213,25015,55213,30059,99160,99208,69];	// 2xx hours (adds a 1% misjump on the end to make the route quicker game-clock time-wise.)
		if($ngHop == 182 && $ngLast == 182) $ngJump_Array = [238,10223,26213,25015,55213,30059,99160,99208,69];	// 2xx hours (adds a 1% misjump on the end to make the route quicker game-clock time-wise.)
		if($ngHop == 182 && $ngLast == 160) $ngJump_Array = [238,10223,26213,25015,55213,30059,160];	// xxx hours
		if($ngHop == 223 && $ngLast == 160) $ngJump_Array = [223,90238,26213,25015,55213,30059,160];	// 183.5 hours
		if($ngHop == 213 && $ngLast == 160) $ngJump_Array = [213,25223,70238,25015,56213,30059,160];	// 181.26 hours
//		}
	}
	if(galaxyNumber == 1 && missionVariables.$ng >470) {
		if($ngHop ==  10 && $ngLast == 192) $ngJump_Array = [10,5172,78012,37010,192];	// 109.93 hours
		if($ngHop == 172 && $ngLast == 192) $ngJump_Array = [172,85012,45010,192];	// 105.47 hours
	}
//	if(galaxyNumber == 2 && System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber, 255),"OPTIMIZED_BY_TIME") ) {
	if(galaxyNumber == 2 && missionVariables.$ng >2) {
		if($ngLast == 255) $ngJump_Array = [ 162,50200,50197, 255]; // start from 200<->162 ->197 -> 255
		if($ngLast == 255 && $ngHop != 162) $ngJump_Array = [ 200,50162,50197, 255];

		if($ngHop == 166 && $ngLast ==  166) $ngJump_Array = [ 166,50011,50083,50226,50083,50226]; // "Hidden Base"!
		if($ngHop ==   11 && $ngLast ==    11) $ngJump_Array = [  11,50166,50083,50226,50083,50226]; // "Hidden Base"!
//		if($ngHop == 166 && $ngLast ==  166) $ngJump_Array = [ 166,1011,1083,1226,1083,1226]; // "Hidden Base"!
//		if($ngHop ==  11 && $ngLast ==   11) $ngJump_Array = [  11,1166,1083,1226,1083,1226]; // "Hidden Base"!
//		if($ngHop ==   54 && $ngLast ==   54) $ngJump_Array = [  54,299]; // Random Jump if no destination set!
//		if($ngHop ==   54 && $ngLast ==   54 && missionVariables.$ng > 9 && missionVariables.$ng < 1000) $ngJump_Array = [118,90093,12121,23183,30121,33183,30121,25183,25121,25183,28121,3186,2183,3186,8183,10186,13183,15186,8183,10186,18183,20186,22183,23186]; // 329.14 hours Route to the BEEHIVE!
//		if($ngHop ==   54 && $ngLast ==   54) $ngJump_Array = [118,90093,12121,23183,30121,33183,30121,25183,25121,25183,28121,3186,2183,3186,8183,10186,13183,15186,8183,10186,18183,20186,22183,23186]; // 329.14 hours Route to the BEEHIVE!
//		if($ngHop ==   54 && $ngLast == 133) $ngJump_Array = [118,90093,12121,23183,30121,33183,30121,25183,25121,25183,28121,3186,2183,3186,8183,10186,13183,15186,8183,10186,17183,42186,82040,24184,31186,40184,50232,62184,133];
//		if($ngHop ==   54 && $ngLast == 206) $ngJump_Array = [118,90093,12121,23183,30121,33183,30121,25183,25121,25183,28121,3186,2183,3186,8183,10186,13183,15186,8183,10186,17183,42186,82040,24184,31186,40184,50232,62184,133,12206,206]; // ~580 hours?
//		if($ngHop == 118 && $ngLast == 118) $ngJump_Array = [118,90093,12121,23183,30121,33183,30121,25183,25121,25183,28121,3186,2183,3186,8183,10186,13183,15186,8183,10186,18183,20186,22183,23186]; // 329.14 hours Route to the BEEHIVE!
//		if($ngHop == 118 && $ngLast == 133) $ngJump_Array = [118,90093,12121,23183,30121,33183,30121,25183,25121,25183,28121,3186,2183,3186,8183,10186,13183,15186,8183,10186,17183,42186,82040,24184,31186,40184,50232,62184,133]; // 548.88 hours or 551 hours to get to 206.
//		if($ngHop == 118 && $ngLast == 206) $ngJump_Array = [118,90093,12121,23183,30121,33183,30121,25183,25121,25183,28121,3186,2183,3186,8183,10186,13183,15186,8183,10186,17183,42186,82040,24184,31186,40184,50232,62184,133,12206,206]; // 550.9 hours
//		else if($ngHop != 133 && $ngHop != 206 && ($ngLast == 133 || $ngLast == 206)) {
//		if($ngHop !=   54 && $ngHop != 118 && $ngHop != 133 && $ngHop != 206 && ($ngLast == 133 || $ngLast == 206)) {
		if($ngHop != 133 && $ngHop != 206 && ($ngLast == 133 || $ngLast == 206 || ($ngHop == 118 && $ngLast == 118) || ($ngHop ==   54 && $ngLast ==   54)) && missionVariables.$ng > 45) {
//			$ngJump_Array = [93,8118,13121,23183,30121,33183,30121,25183,25121,25183,28121,3186,2183,3186,8183,10186,13183,15186,8183,10186,17183,42186,82040,24184,31186,40184,50232,62184,133]; // 523.46 hours

// I need to do a distance check to determine which starting system to use to get to 133 or 206.
//	This route should probably only become available MUCH LATER!
// WyldRide jump path creator!
			$ngJump_Array = new Array();
			$ngCounter = Math.log(player.score+1);
			if(system.ID != 118) {
				$ngJump_Array = System.infoForSystem(galaxyNumber,system.ID).routeToSystem(System.infoForSystem(galaxyNumber,118), "OPTIMIZED_BY_TIME").route;
			} else $ngJump_Array = [118];
			this.choice(Math.floor(17+Math.min(23,Math.random()*(2+$ngCounter*0.5))));
			var i2 = Math.ceil(Math.max(3,(Math.random()+Math.random()+Math.random())*Math.max(2,10-$ngCounter)));
			for(var i3=0; i3< i2; i3++) this.choice(Math.floor(59+Math.random()*3));
			this.choice(Math.floor(28+Math.min(6,(i2-3+Math.random())*2)));
			this.choice(Math.floor(35+Math.random()*3));
			this.choice(Math.min(16,Math.floor((Math.random()+Math.random())*(6+2*$ngCounter))));
			this.choice(Math.floor(62+Math.random()*3));
			if(($ngLast == 133 || $ngLast == 206) && missionVariables.$ng >1475) {
			var i2 = Math.max(1,Math.ceil((Math.random()+Math.random())*(5-($ngCounter*0.5))));
			for(var i3=0; i3< i2; i3++) this.choice(Math.floor(65+Math.random()*3));
			var i2 = Math.ceil(Math.max(2,(Math.random()+Math.random())*(5-($ngCounter*0.5))));
			for(var i3=0; i3< i2; i3++) this.choice(Math.floor(68+Math.random()*3));
			this.choice(Math.floor(24+Math.random()*4));
			var i2 = Math.ceil(Math.max(2,(Math.random()+Math.random())*(5-($ngCounter*0.5))));
			for(var i3=0; i3< i2; i3++) this.choice(Math.floor(71+Math.random()*3));
			this.choice(Math.min(58,Math.floor(Math.random()*Math.random()*8+$ngCounter+38)));
			}
			$ngCounter = 1;
//			if($ngLast == 206) $ngJump_Array = $ngJump_Array.concat([12206,206]);
//			if(system.ID != $ngJump_Array[0] && $ngJump_Array.length > 1 && $ngJump_Array[0] < 256) $ngJump_Array = System.infoForSystem(galaxyNumber,system.ID).routeToSystem(System.infoForSystem(galaxyNumber,$ngJump_Array[0]), "OPTIMIZED_BY_TIME").route.concat($ngJump_Array.slice(1, $ngJump_Array.length));
		}
	}
	if(galaxyNumber == 3 && missionVariables.$ng >470) {
		if($ngHop ==  27 || $ngLast ==  50) $ngJump_Array = [  27,50239,  50]; // 27/50 sharp angle jump pair.
		if($ngHop ==  50 || $ngLast ==  27 && $ngHop !=  27) $ngJump_Array = [  50,50239,  27];
		if($ngHop ==  70 || $ngLast == 178) $ngJump_Array = [  70, 120, 178];
		if($ngHop ==  49 || $ngLast ==  54) $ngJump_Array = [  49,50054,  54];
		if($ngHop ==  83 || $ngLast ==  95) $ngJump_Array = [  83,50149, 149,  54,75049,  49,75095,  95];
		if($ngHop ==  95 || $ngLast ==  83 && $ngHop !=  83) $ngJump_Array = [  95,4054,  83];
		if($ngHop ==  54 || $ngLast ==  49 && $ngHop !=  49) $ngJump_Array = [  54,75049,  49];
		if($ngHop == 149 || $ngLast ==  83 && $ngHop !=  83 && $ngHop !=  95) $ngJump_Array = [ 149,87083,  83];
		if($ngHop == 114 || $ngLast ==  83 && $ngHop !=  83 && $ngHop !=  95 && $ngHop != 149) $ngJump_Array = [ 114,50149,87083,  83];
		if($ngHop == 156 || $ngLast == 172) $ngJump_Array = [ 156,50178, 172]; // 156/172 "trade routes"
		if($ngHop == 172 || $ngLast == 156 && $ngHop != 156) $ngJump_Array = [ 172,50178,87156, 156];
	}
	if(galaxyNumber == 4 && missionVariables.$ng >470) {
		if($ngHop ==  41 || $ngLast == 186) $ngJump_Array = [  41,50222,87186, 186]; // 41/186 sharp angle jump pair.
		if($ngHop == 186 || $ngLast ==  41 && $ngHop !=  41) $ngJump_Array = [ 186,50222,50041,  41];
		if($ngHop == 148 || $ngLast == 208) $ngJump_Array = [ 148,50164,50208, 208]; // 148/208 sharp angle jump pair.
		if($ngHop == 208 || $ngLast == 148 && $ngHop != 148) $ngJump_Array = [ 208,50164,50148, 148];
		if($ngHop ==  81 || $ngLast == 160) $ngJump_Array = [  81,75213, 160]; // 81/160 sharp angle jump pair.
		if($ngHop == 160 || $ngLast ==  81 && $ngHop !=  81) $ngJump_Array = [ 160,87213,  81];
	}
	if(galaxyNumber == 5 && missionVariables.$ng >470) {
		if($ngHop ==  36 || $ngLast == 214) $ngJump_Array = [36,40221,73045,59036,214]; // 125.62 hours
		if($ngHop ==  45 || $ngLast == 214) $ngJump_Array = [45,19221,63036,214]; // 100.24 hours 45/154/221->214 path across void.
		if($ngHop == 154 || $ngLast == 214 && $ngHop !=  45) $ngJump_Array = [154,45,19221,63036,214]; // 123.82 hours
		if($ngHop == 221 || $ngLast == 214 && $ngHop !=  45 && $ngHop != 154) $ngJump_Array = [221,80045,62036,214]; // 125.13 hours
		if($ngHop == 251 || $ngLast == 238) $ngJump_Array = [251,50137,238];	// 69.77 hours
		if($ngHop == 137 || $ngLast == 238) $ngJump_Array = [137,12251,238];	// 53.32 hours
		if($ngHop == 244 || $ngLast == 108) $ngJump_Array = [244,1026,108];	// 46.87 hours
		if($ngHop == 244 || $ngLast == 222) $ngJump_Array = [244,1026,23108,193];	// 46.49 hours
		if($ngHop == 244 || $ngLast == 222) $ngJump_Array = [244,1026,23108,193,181,17,89,1148,100,80199,222];	// 177.98 hours
	}
	if(galaxyNumber == 6 && missionVariables.$ng >470) {
		if($ngLast == 192 && !System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber, 192),"OPTIMIZED_BY_TIME") ) {
			if(System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,17), "OPTIMIZED_BY_TIME").distance < System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,178), "OPTIMIZED_BY_TIME").distance) {
				$ngJump_Array = System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,17), "OPTIMIZED_BY_TIME").route.concat([24178,50192,192]); // 62.23 hours
			} else {
				$ngJump_Array = System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,178), "OPTIMIZED_BY_TIME").route.concat([17017,192]); // 58.99 hours
			}
		}
		if($ngLast == 229 && !System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber, 229),"OPTIMIZED_BY_TIME") ) {
			if(System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,89), "OPTIMIZED_BY_TIME").distance < System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,194), "OPTIMIZED_BY_TIME").distance) {
				$ngJump_Array = System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,89), "OPTIMIZED_BY_TIME").route.concat([40194,50229,229]); // 74.52 hours
			} else {
				$ngJump_Array = System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,194), "OPTIMIZED_BY_TIME").route.concat([10089,49229,229]); // 53.24 hours
			}
		}
		if($ngLast == 178 && !System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber, 178),"OPTIMIZED_BY_TIME") ) {
			if(System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,36), "OPTIMIZED_BY_TIME").distance < System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,212), "OPTIMIZED_BY_TIME").distance) {
				$ngJump_Array = System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,36), "OPTIMIZED_BY_TIME").route.concat([91212,41180,36192,178]); // 95.71 hours
			} else {
				$ngJump_Array = System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,212), "OPTIMIZED_BY_TIME").route.concat([8036,41180,36192,178]); // 90.88 hours
			}
		}
		if($ngLast == $ngHop) {

		if($ngHop ==  53 || $ngHop ==  77 || $ngHop == 188) $ngJump_Array = [188,50243,45053,25077,25243,40011,50077,50011,40077,173]; // 250.43 hours

		if($ngHop ==  17) $ngJump_Array = [17,24178,50192,192]; // 62.23 hours
		if($ngHop ==178) $ngJump_Array = [178,17017,192]; // 58.99 hours - FASTEST!
		if($ngHop ==  89) $ngJump_Array = [89,40194,50229,229]; // 74.52 hours
		if($ngHop ==194) $ngJump_Array = [194,10089,49229,229]; // 53.24 hours

		if($ngHop ==  36) $ngJump_Array = [36,91212,41180,36192,178]; // 95.71 hours
		if($ngHop ==  46) $ngJump_Array = [46,45212,66192,178]; // 99.09 hours
		if($ngHop ==114) $ngJump_Array = [212,8036,41180,36192,178]; // 91.55 hours
		if($ngHop ==180) $ngJump_Array = [180,7036,25212,44192,178]; // 99.18 hours
		if($ngHop ==192) $ngJump_Array = [192,66212,25046,24180,29192,178]; // 96.07 hours
		if($ngHop ==212) $ngJump_Array = [212,8036,41180,36192,178]; // 90.88 hours
		}
	}
	if(galaxyNumber == 7 && missionVariables.$ng >475) {
		if($ngLast == 162) {
			if(System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,9), "OPTIMIZED_BY_TIME").distance < System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,121), "OPTIMIZED_BY_TIME").distance) {
				$ngJump_Array = System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,9), "OPTIMIZED_BY_TIME").route.concat([24088,65121,45088,49162,162]); // 124.05 hours
			} else {
				$ngJump_Array = System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,121), "OPTIMIZED_BY_TIME").route.concat([54009,65088,23121,162]); // 130.97 hours
			}
		}
		if($ngHop ==  97 || $ngLast ==  43) $ngJump_Array = [97,1061,43]; // 46.78 hours
		if($ngHop ==  61 || $ngLast ==  43) $ngJump_Array = [61,5097,43]; // 48.88 hours
		if($ngHop ==  16 || $ngLast ==144) $ngJump_Array = [16,59161,19255,144]; // 100.61 hours
		if($ngHop ==  16 || $ngLast ==247) $ngJump_Array = [16,59161,19255,247]; // 100.61 hours
		if($ngHop ==161 || $ngLast ==247) $ngJump_Array = [161,40016,19255,247]; // 91.74 hours
		if($ngHop ==161 || $ngLast ==144) $ngJump_Array = [161,40016,19255,144]; // 91.74 hours
		if($ngHop ==  29 || $ngLast ==153) $ngJump_Array = [29,50059,153];
		if($ngLast == $ngHop) {
			if($ngHop ==    2) $ngJump_Array = [2,88,76009,65121,45088,49162,162]; // 145.33 hours	(142.63 hours with 0.1% misjump to 88)
//			if($ngHop ==    2) $ngJump_Array = [2,88,9,50121,50088,50118,50088,162]; // 209.97 hours
//			if($ngHop ==    9) $ngJump_Array = [9,50121,50088,50118,50088,50162, 162]; // 179.69 hours 9<->121 pair to 162.Oresrati
			if($ngHop ==    9) $ngJump_Array = [9,24088,65121,45088,49162,162]; // 124.05 hours
			if($ngHop ==  88) $ngJump_Array = [88,76009,65121,45088,162]; // 134.15 hours
			if($ngHop ==121) $ngJump_Array = [121,54009,65088,23121,162]; // 130.97 hours		6.8LY, 6LY, 6.4LY, 6.8LY
			if($ngHop ==118) $ngJump_Array = [121,54009,65088,23121,162]; // 130.97 hours 118->121 route to 162 131.3 hours
			if($ngHop ==137) $ngJump_Array = [121,54009,65088,23121,162]; // 130.97 hours		6.8LY, 6LY, 6.4LY, 6.8LY
			if($ngHop ==147) $ngJump_Array = [9,24088,65121,45088,49162,162]; // 124.05 hours
		}
	}
// End of Galaxy Chart shortcut tables.


	if($ngJump_Array[0] < 0) {
		if(system.ID == player.ship.targetSystem) {
// THIS is where I need to add "...and then something bad happens!"
// 299 = Jumps to a random nearby system. Jump Counter starts from 0 to simplify things.
			$ngJump_Array = [299]; // was [299, -1];
			$ngCounter = 0;
		} else {

// Sets a jump Path route from current starting system to targeted destination system since one wasn't set by a pre-programmed route.
// DOES NOT HANDLE UNREACHABLE SYSTEMS...yet! But at least it now CHECKS if the destination is unreachable!
			if(System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber, $ngLast),"OPTIMIZED_BY_TIME") ) {
				$ngJump_Array = System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,$ngLast), "OPTIMIZED_BY_TIME").route;
			} else {
				player.commsMessage("Destination unreachable through ordinary jumps!",6);
// Maybe later splice in a pre-programmed routes to cross voids to unreachable systems, though this only seems possible to Galaxy 7.
			}
		}
	} else {

// Splices a jump Path route from current location to the starting point of a pre-programmed route ONTO the pre-programmed route!
		if($ngHop != $ngJump_Array[0] && $ngJump_Array.length > 1 && $ngJump_Array[0] < 256) {
			$ngJump_Array = System.infoForSystem(galaxyNumber,$ngHop).routeToSystem(System.infoForSystem(galaxyNumber,$ngJump_Array[0]), "OPTIMIZED_BY_TIME").route.concat($ngJump_Array.slice(1, $ngJump_Array.length));
		}
	}
		if(system.isInterstellarSpace || $ngHop != system.ID) {
			$ngCounter = 0; // Sets first jump to the starting system from interstellar space.
		}

// Announces Jump Starting Time. Used to calculate total travel time much later.
			ngStartTime = clock.seconds;
			player.commsMessage("Jump chain starting from "+system.ID+" and going to "+player.ship.targetSystem+" or "+$ngLast+" for "+$ngDis+" LY distance, starting at "+clock.clockString,6);
			if(worldScripts['nullgate'].logging) log(this.name,"Jump Path: ",$ngJump_Array," system.ID, $ngHop, $ngLast, player.ship.targetSystem, $ngCounter, last jump in array: ",system.ID,$ngHop,$ngLast,player.ship.targetSystem,$ngCounter,$ngJump_Array.length,$ngJump_Array[($ngJump_Array.length)-1]);
// puts a -7 value on the end to mark the end of jump Path chain!
			if($ngJump_Array[0] > -2) $ngJump_Array.push("-7");
// Moves the player's ship far away from anything in the system and then launches the subroutine to begin first hyperspace jump.
			if($ngCounter > -1) {
//				player.ship.position = [-1000000-Math.random()*1000000, -1000000-Math.random()*1000000, -1000000-Math.random()*1000000];
				player.ship.position = [-9E6*(1+Math.random()),-9E6*(1+Math.random()),-9E6*(1+Math.random())];
				if($ngAngry < 100*Math.random() || ($ngHop == $ngLast && missionVariables.$ng <400)) this.$ngJumping();	// If Null Gate is ANGRY, it will not send you out-of-system...instead it will send you FAR from the WP beacon, planet, and star ...causing a LONG trip back or forcing a manual hyperspace jump to elsewhere.
//				if($ngAngry < 100*Math.random() ) this.$ngJumping();	// If Null Gate is ANGRY, it will not send you out-of-system...instead it will send you FAR from the WP beacon, planet, and star ...causing a LONG trip back or forcing a manual hyperspace jump to elsewhere.
			}
		}
	} // Added to prevent undefined results!
}

// WyldRide jump path creator!
this.choice = function(choice)
{
	switch(choice)
	{
		case  1:	{ $ngJump_Array = $ngJump_Array.concat([2883,2886,3372,4369,4183,6186,6883,7886,7372,8369,8183,9186,9883,10886,10372,12369,12183,13186,13883,15886]); break;	}
		case  2:	{ $ngJump_Array = $ngJump_Array.concat([2372,2369,3883,4886,5183,6186,7372,8369,9883,10886,11183,12186,13372,14369,15883,35886]); break;	}
		case  3:	{ $ngJump_Array = $ngJump_Array.concat([2183,2186,3372,4886,5883,7369,9183,10186,12372,13886,15883,17369]); break;	}
		case  4:	{ $ngJump_Array = $ngJump_Array.concat([2883,2886,3183,4186,5372,7369,9883,10886,12183,14186,18372,20369]); break;	}
		case  5:	{ $ngJump_Array = $ngJump_Array.concat([2372,3369,4883,3886,4183,6186,7372,9369,13883,15886,17183,18186]); break;	}
		case  6:	{ $ngJump_Array = $ngJump_Array.concat([8183,10186,8372,10369,8883,10886,8183,10186,18372,20369]); break;	}
		case  7:	{ $ngJump_Array = $ngJump_Array.concat([8883,10886,8183,10186,8372,10369,8883,10886,19183,20186]); break;	}
		case  8:	{ $ngJump_Array = $ngJump_Array.concat([8372,10369,13883,15886,8183,10186,12372,14369,19883,18886]); break;	}
		case  9:	{ $ngJump_Array = $ngJump_Array.concat([8183,10186,13372,15369,8883,10886,8183,10186,18372,20369]); break;	}
		case 10:	{ $ngJump_Array = $ngJump_Array.concat([8883,10886,13183,15186,8372,8369,13883,15886,19183,18186]); break;	}
		case 11:	{ $ngJump_Array = $ngJump_Array.concat([8372,10369,13883,15886,13183,15186,16372,17369]); break;	}
		case 12:	{ $ngJump_Array = $ngJump_Array.concat([8183,10186,13372,15369,13883,15886,19183,20186]); break;	}
		case 13:	{ $ngJump_Array = $ngJump_Array.concat([8372,10369,7883,8886,13183,15186,19372,18369]); break;	}
		case 14:	{ $ngJump_Array = $ngJump_Array.concat([8183,10186,8372,10369,8883,10886,16183,18186]); break;	}
		case 15:	{ $ngJump_Array = $ngJump_Array.concat([8883,8886,10183,12186,12372,15369,17883,18886]); break;	}
		case 16:	{ $ngJump_Array = $ngJump_Array.concat([6883,6886,7183,9886,13883,15186,17883,18886]); break;	}
		case 17:	{ $ngJump_Array = $ngJump_Array.concat([66666,75861,80885,85462,90434,79793,23372]); break;	}
		case 18:	{ $ngJump_Array = $ngJump_Array.concat([80821,20462,30886,35462,35369,35793,35886,50462,23883]); break;	}
		case 19:	{ $ngJump_Array = $ngJump_Array.concat([50093,50462,35793,10883,20821,25372]); break;	}
		case 20:	{ $ngJump_Array = $ngJump_Array.concat([50434,50793,50462,25093,20883]); break;	}
		case 21:	{ $ngJump_Array = $ngJump_Array.concat([85821,80793,23372]); break;	}
		case 22:	{ $ngJump_Array = $ngJump_Array.concat([50121,81462,20883]); break;	}
		case 23:	{ $ngJump_Array = $ngJump_Array.concat([28821,78462,23883]); break;	}
		case 24:	{ $ngJump_Array = $ngJump_Array.concat([50515,50884,50186]); break;	}
		case 25:	{ $ngJump_Array = $ngJump_Array.concat([50740,50184,50369]); break;	}
		case 26:	{ $ngJump_Array = $ngJump_Array.concat([50515,50884,50886]); break;	}
		case 27:	{ $ngJump_Array = $ngJump_Array.concat([50040,50371,50886]); break;	}
		case 28:	{ $ngJump_Array = $ngJump_Array.concat([29821,35883,33821]); break;	}
		case 29:	{ $ngJump_Array = $ngJump_Array.concat([25434,26883,29434]); break;	}
		case 30:	{ $ngJump_Array = $ngJump_Array.concat([25821,25883,28434]); break;	}
		case 31:	{ $ngJump_Array = $ngJump_Array.concat([25434,28372,30821]); break;	}
		case 32:	{ $ngJump_Array = $ngJump_Array.concat([25821,4434]); break;	}
		case 33:	{ $ngJump_Array = $ngJump_Array.concat([28434]); break;	}
		case 34:	{ $ngJump_Array = $ngJump_Array.concat([30434,35883,33821]); break;	}
		case 35:	{ $ngJump_Array = $ngJump_Array.concat([3886,2372,3369]); break;	}
		case 36:	{ $ngJump_Array = $ngJump_Array.concat([3369,2883,3886]); break;	}
		case 37:	{ $ngJump_Array = $ngJump_Array.concat([3886,2372,3886]); break;	}
		case 38:	{ $ngJump_Array = $ngJump_Array.concat([40884,52932,52884,23323,20829,20371,20829,30884,30829,30371,30829,30884,30829,99349,50256,306,406,506,606,706,806,906]); break;	}
		case 39:	{ $ngJump_Array = $ngJump_Array.concat([52184,23323,20829,20371,20829,30884,30829,30371,30829,30884,30829,99349,50256,606,906]); break;	}
		case 40:	{ $ngJump_Array = $ngJump_Array.concat([52371,23323,20829,20371,99422,50256,606]); break;	}
		case 41:	{ $ngJump_Array = $ngJump_Array.concat([40184,69133,99349,50256,206,306,406,506,606,706,806,906]); break;	}
		case 42:	{ $ngJump_Array = $ngJump_Array.concat([40884,79422,99349,50256,206,306,406,506,606,706,806,906]); break;	}
		case 43:	{ $ngJump_Array = $ngJump_Array.concat([40371,89833,99349,50256,206,606,906]); break;	}
		case 44:	{ $ngJump_Array = $ngJump_Array.concat([40184,133,206,306,406]); break;	}
		case 45:	{ $ngJump_Array = $ngJump_Array.concat([40371,422,906,606,306]); break;	}
		case 46:	{ $ngJump_Array = $ngJump_Array.concat([40884,833,349,906,422]); break;	}
		case 47:	{ $ngJump_Array = $ngJump_Array.concat([40884,89422,666]); break;	}
		case 48:	{ $ngJump_Array = $ngJump_Array.concat([40184,133,906]); break;	}
		case 49:	{ $ngJump_Array = $ngJump_Array.concat([40371,133,349]); break;	}
		case 50:	{ $ngJump_Array = $ngJump_Array.concat([40884,833,906]); break;	}
		case 51:	{ $ngJump_Array = $ngJump_Array.concat([40371,422,206]); break;	}
		case 52:	{ $ngJump_Array = $ngJump_Array.concat([40184,133,306]); break;	}
		case 53:	{ $ngJump_Array = $ngJump_Array.concat([40371,833,606]); break;	}
		case 54:	{ $ngJump_Array = $ngJump_Array.concat([40884,422,966]); break;	}
		case 55:	{ $ngJump_Array = $ngJump_Array.concat([40184,133]); break;	}
		case 56:	{ $ngJump_Array = $ngJump_Array.concat([50184,5232,133]); break;	}
		case 57:	{ $ngJump_Array = $ngJump_Array.concat([40884,89422,666]); break;	}
		case 58:	{ $ngJump_Array = $ngJump_Array.concat([35184,133]); break;	}
		case 59:	{ $ngJump_Array = $ngJump_Array.concat([25121,25883]); break;	}
		case 60:	{ $ngJump_Array = $ngJump_Array.concat([25434,25183]); break;	}
		case 61:	{ $ngJump_Array = $ngJump_Array.concat([25821,25372]); break;	}
		case 62:	{ $ngJump_Array = $ngJump_Array.concat([22183,24886]); break;	}
		case 63:	{ $ngJump_Array = $ngJump_Array.concat([22883,24369]); break;	}
		case 64:	{ $ngJump_Array = $ngJump_Array.concat([22372,24186]); break;	}
		case 65:	{ $ngJump_Array = $ngJump_Array.concat([50740,50186]); break;	}
		case 66:	{ $ngJump_Array = $ngJump_Array.concat([50515,50369]); break;	}
		case 67:	{ $ngJump_Array = $ngJump_Array.concat([50040,50886]); break;	}
		case 68:	{ $ngJump_Array = $ngJump_Array.concat([50040,50323]); break;	}
		case 69:	{ $ngJump_Array = $ngJump_Array.concat([50515,50232]); break;	}
		case 70:	{ $ngJump_Array = $ngJump_Array.concat([50740,50932]); break;	}
		case 71:	{ $ngJump_Array = $ngJump_Array.concat([50184,50932]); break;	}
		case 72:	{ $ngJump_Array = $ngJump_Array.concat([50884,50323]); break;	}
		case 73:	{ $ngJump_Array = $ngJump_Array.concat([50371,50232]); break;	}
	}
}

/*
// So long as curX and curY is defined before calling this, it can find the nearest 2 systems to ANY X,Y coordinate!
this.findNearestSystem = function()
{
// Stores player ship current location's X and Y
	var curX = Math.floor(player.ship.galaxyCoordinates.x);
	var curY = Math.floor(player.ship.galaxyCoordinates.y);

	var shortDis = 9999;
	for (var i=0; i< 256; i++) {
		if(i != system.ID || system.isInterstellarSpace) {
			var swiDestX = Math.floor(System.infoForSystem(galaxyNumber,i).internalCoordinates.x);
			var swiDestY = Math.floor(System.infoForSystem(galaxyNumber,i).internalCoordinates.y);
			var xDif = Math.floor(Math.abs(curX - swiDestX));
			var yDif = Math.floor(Math.abs(curY - swiDestY)*0.5);
			var iDis = 0.4*Math.floor(Math.sqrt(xDif*xDif + yDif*yDif));
			iDis = Number(iDis.toFixed(1));

			var iDis2 = Math.floor(10*System.infoForSystem(galaxyNumber, system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,i)))/10;
//			if(worldScripts['nullgate'].logging) log(this.name,parseInt(i),".LY distance = ",iDis," vs ",iDis2," Cur x,y:",curX,curY,"Dest x,y:",swiDestX,swiDestY," xDif,yDif:",xDif,yDif);

//			if(iDis <= 7) if(iDis <= shortDis) {
			if(iDis <= 7) {
// If that route exists, THEN check the time to do it. If time needed is less than previous "best route", use this route instead.

// MUCH better now done to determine if the path to $ngLast is reachable normally...and if so, then compare route distances rather than straight-line distances.
// Instead of checking for only the 2 closest systems, do chain distance tests from any reachable system to destination.
			if(System.infoForSystem(galaxyNumber,i).routeToSystem(System.infoForSystem(galaxyNumber, $ngLast),"OPTIMIZED_BY_TIME") ) {
				var iDis = iDis*iDis + System.infoForSystem(galaxyNumber,i).routeToSystem(System.infoForSystem(galaxyNumber,$ngLast), "OPTIMIZED_BY_TIME").time; // needs to be the amount of TIME, not the jump-route!
			} else {
				var iDis = iDis + System.infoForSystem(galaxyNumber, i).distanceToSystem(System.infoForSystem(galaxyNumber, $ngLast));
				if(iDis <7) {
//					iDis = 0;
					iDis = iDis*iDis;
				} else {
					iDis = 600 + iDis*iDis;
				}
			}
				if(iDis <= shortDis) {
					shortDis = iDis;
					$ngHop = i;
				}
			}
		}
	}

//	player.commsMessage("shortDis 1&2 and $ngDis: "+shortDis+", "+$ngDis+" LY for systems "+$ngHop+", "+$ngLast+", "+player.ship.targetSystem,6);
//	if(worldScripts['nullgate'].logging) log(this.name,"shortest time: ",shortDis," hours and $ngDis distance: ",$ngDis," LY from system ",system.ID," to systems ",$ngHop,$ngLast,player.ship.targetSystem);
//	player.commsMessage("Nearest systems: "+system.info.systemsInRange(7.0),6);

// Compares both closest systems + remaining route TIME-WISE to just going straight to $ngLast if total jumpDis < 7 LY.
	if(shortDis >= $ngDis*$ngDis && $ngDis <7.0) { // $ngDis = jumpDis? does it go undefined/null after each jump?
		$ngHop = $ngLast;
//		player.commsMessage("Jumping straight to destination!",6);
	}
}
*/

this.$ngJumping = function()
{
// Records current location x and y.
//		var curX = player.ship.galaxyCoordinates.x;
//		var curY = player.ship.galaxyCoordinates.y;
		var curX = Math.floor(player.ship.galaxyCoordinates.x);
		var curY = Math.floor(player.ship.galaxyCoordinates.y);

		if(worldScripts['nullgate'].logging) log(this.name,"VERY Precheck Jump count: "+$ngCounter+" jumping to: "+$ngHop+" from: "+system.ID+" total Jump Path: "+$ngJump_Array);
// Check for jump errors and quicker times via misjumps

//	if($ngHop > -1 && $ngCounter > -1 && $ngCounter <$ngJump_Array.length) {	// Checks if there's more jumps to be done.
//	if($ngCounter > -1 && $ngCounter <$ngJump_Array.length && system.ID != parseInt($ngJump_Array[$ngJump_Array.length-1]) && missionVariables.$ng > 30) {	// Checks if there's more jumps to be done.
	if($ngCounter > -1 && $ngCounter <$ngJump_Array.length -1 && system.ID != parseInt($ngJump_Array[$ngJump_Array.length-2]) && missionVariables.$ng > 30) {	// Checks if there's more jumps to be done.
//		if(system.isInterstellarSpace && $ngCounter >0) $ngCounter --;	// If in interstellar space, retry last jump!
//		if( (system.ID <0 || system.ID >255) && $ngCounter >0) $ngCounter --;	// If in interstellar space, retry last jump!
//		if(system.ID != parseInt($ngJump_Array[$ngCounter-1]) && $ngCounter >0) $ngCounter --;	// Not where expected to be, retry last jump!
		$ngHop = parseInt($ngJump_Array[$ngCounter]);	// Sets next system to jump to...
		if(system.ID == $ngHop && $ngCounter <$ngJump_Array.length-1) {	// Already at next jump location somehow...
			$ngCounter++;
			$ngHop = parseInt($ngJump_Array[$ngCounter]);	// Sets next system to jump to...
//	This ELSE isn't "safe" to do if jumper tries to find misjump "shortcuts" as well!
//		} else if($ngCounter >0 && system.ID != parseInt($ngJump_Array[$ngCounter-1]) && parseInt($ngJump_Array[$ngCounter-1]) < 256 && parseInt($ngJump_Array[$ngCounter-1]) > -1) {
		} else if($ngCounter >0 && system.ID != $ngPast && $ngPast < 256 && $ngPast > -1) {
			$ngCounter --;	// If last jump was to a regular system but ended up somewhere else, retry last jump! (in future do distance checks for next jump?)
			$ngHop = parseInt($ngJump_Array[$ngCounter]);	// Sets next system to jump to...
		}
//		log(this.name," system.ID, $ngHop, Last Jump: ",system.ID,$ngHop,player.ship.targetSystem," count: ",$ngCounter,$ngJump_Array.length,"Jump Path: ",$ngJump_Array);
		var $ngMisjumpPercent = Math.floor($ngHop/1000);
		var $ngDestination = $ngHop - $ngMisjumpPercent*1000;
		if($ngDestination > 699 && $ngDestination < 1000) $ngDestination = $ngDestination - 700;
		if($ngDestination > 299 && $ngDestination < 600) $ngDestination = 555 - $ngDestination;
//		if($ngDestination < 0) $ngDestination = 299;
		if(worldScripts['nullgate'].logging) log(this.name,"Check 1: system.ID, $ngHop, $ngDestination, $ngMisjumpPercent, TargetSystem, Last Jump: ",system.ID,$ngHop, $ngDestination, $ngMisjumpPercent, player.ship.targetSystem, $ngJump_Array[$ngJump_Array.length-2],$ngPast," count: ",$ngCounter,$ngJump_Array.length);

// Only if $ngHop is to a regular system does it currently try to find a quicker misjump! No check is made for single-jumps, otherwise fine-tuning and testing would be harder!
//		if($ngCounter <$ngJump_Array.length && $ngJump_Array.length >2 && $ngHop > -1 && $ngHop < 1000 && !system.isInterstellarSpace ) {
//		if($ngCounter <$ngJump_Array.length && $ngJump_Array.length >2 && $ngHop > -1 && $ngHop < 1000 && (($ngPast >999 && $ngHop != $ngPast - Math.floor($ngPast/1000)*1000) ||  ($ngPast <1000 && $ngHop != $ngPast)) ) {
//		if($ngCounter <$ngJump_Array.length-1 && $ngJump_Array.length >2 && $ngHop > -1 && $ngHop < 1000 && $ngHop != $ngPast - Math.floor($ngPast/1000)*1000 ) {
//		if($ngCounter <$ngJump_Array.length && $ngHop < 1000) { // Only if $ngHop is to a regular system does it currently try to find a quicker misjump!
//		if($ngCounter <$ngJump_Array.length && $ngJump_Array.length >2 && $ngDestination < 256 && $ngHop > -1 && $ngHop < 1000 && $ngHop != $ngPast - Math.floor($ngPast/1000)*1000 && missionVariables.$ng > 470 ) {
		if($ngCounter <$ngJump_Array.length-1 && $ngJump_Array.length >2 && $ngDestination < 256 && $ngHop > -1 && $ngHop < 1000 && $ngHop != $ngPast - Math.floor($ngPast/1000)*1000 && missionVariables.$ng > 470 ) {
// Stores player ship current location's X and Y
			var curX = Math.floor(player.ship.galaxyCoordinates.x);
			var curY = Math.floor(player.ship.galaxyCoordinates.y);
			var $ngDestX = Math.floor(System.infoForSystem(galaxyNumber,$ngDestination).internalCoordinates.x);
			var $ngDestY = Math.floor(System.infoForSystem(galaxyNumber,$ngDestination).internalCoordinates.y);
			var xDif = Math.floor(Math.abs(curX - $ngDestX));
			var yDif = Math.floor(Math.abs(curY - $ngDestY)*0.5);
			var iDis = 0.4*Math.floor(Math.sqrt(xDif*xDif + yDif*yDif));
			var iDis = Number(iDis.toFixed(1));
			var iTime = Number((iDis*iDis).toFixed(2));
			var $ngMisjumpPercent2 = 999;
			var i3Time = iTime-0.1;	// Target time to beat is 0.1 hours less than original iTime.
			if(iDis <= 7 && iDis > 0) {
			if(worldScripts['nullgate'].logging) log(this.name,"LY distance = ",iDis," Cur x,y:",curX,curY,"Dest x,y:",$ngDestX,$ngDestY," xDif,yDif:",xDif,yDif," Time: ",iTime);
			for (var i=1; i< 100; i++) {
//			for (var i=99; i>0; i--) {
				var x1Dif = xDif*i/100;
				if(curX - $ngDestX > 0) var x1Dif=-x1Dif;	// seems easier to do this than to figure out how to make xDif pos or negative above.
				var y1Dif = yDif*i/100;
				if(curY - $ngDestY > 0) var y1Dif=-y1Dif;
				var a1LX = Math.floor(curX + x1Dif);
				var a1LY = Math.floor(curY + y1Dif);
				var i1Dis = 0.4*Math.floor(Math.sqrt(x1Dif*x1Dif + y1Dif*y1Dif));
				var i1Dis = Number(i1Dis.toFixed(1));
				var x2Dif = Math.floor(Math.abs(a1LX - $ngDestX));
				var y2Dif = Math.floor(Math.abs(a1LY - $ngDestY)*0.5);
				var i2Dis = 0.4*Math.floor(Math.sqrt(x2Dif*x2Dif + y2Dif*y2Dif));
				var i2Dis = Number(i2Dis.toFixed(1));
				var i2Time = Number((i2Dis*i2Dis).toFixed(2));
//				var i1Time = iTime - i2Time;	// i1Time is FAR more than i1Dis*i1Dis!
//				var i1Time = Number(((iDis*iDis)-(iDis-i1Dis)*(iDis-i1Dis)).toFixed(2));
				var i1Time = Number((((2*i/100)-((i/100)*(i/100)))*iTime).toFixed(2));	// The generalised formula is that a misjump of fraction 'f' (0..1) towards the destination takes (2f - f^2) as long as the original jump would have.
				if(i1Time < 0.1) var i1Time=0.1;	// Minimum jump time has been increased to 0.1 hours to avoid 0 hour, 0 distance jumping.
				if(i2Time < 0.1) var i2Time=0.1;	// Minimum jump time has been increased to 0.1 hours to avoid 0 hour, 0 distance jumping.
				var i3Dis = iDis-i1Dis-i2Dis; // i3Dis should be very close to 0!
//				var i2Time = Number(((i1Dis*i1Dis)+(i2Dis*i2Dis)).toFixed(2));	// OBVIOUSLY incorrect! 	i1Time is FAR more than i1Dis*i1Dis!
//			if(worldScripts['nullgate'].logging) log(this.name,parseInt(i),".LY distance = ",iDis,i1Dis,i2Dis,i3Dis," Cur x,y:",curX,curY,"Dest x,y:",$ngDestX,$ngDestY,a1LX,a1LY," xDif,yDif:",xDif,yDif,x1Dif,y1Dif,x2Dif,y2Dif," Time Dif: ",iTime,i1Time,i2Time,(iTime-i1Time-i2Time));
				if(i1Time + i2Time < i3Time) {
//				if(i1Dis + i2Dis < iDis -0.02) {
					var i3Time = i1Time + i2Time;
					var $ngMisjumpPercent2 = i;
					if(worldScripts['nullgate'].logging) log(this.name,i," $ngMisjumpPercent2 ", $ngMisjumpPercent2," LY distance = ",iDis,i1Dis,i2Dis,i3Dis," Cur x,y:",curX,curY,"Dest x,y:",$ngDestX,$ngDestY,a1LX,a1LY," xDif,yDif:",xDif,yDif,x1Dif,y1Dif,x2Dif,y2Dif," Time Dif: ",i3Time," vs ",iTime,i1Time,i2Time,(iTime-i1Time-i2Time));
//					log(this.name,parseInt(i),".LY distance = ",iDis,i1Dis,i2Dis,i3Dis," Cur x,y:",curX,curY,"Dest x,y:",$ngDestX,$ngDestY," xDif,yDif:",xDif,yDif," Time Dif: ",i3Time," vs ",iTime);
				}
			}
			}
			if($ngMisjumpPercent2 < 999) {	// This means a quicker time is found via a misjump, so use that misjump distance instead and roll back the jump count by 1.
				var $ngMisjumpPercent = $ngMisjumpPercent2;
				$ngHop = $ngDestination + $ngMisjumpPercent*1000;
				$ngCounter--;	// Causes havoc with logic above to retry previous jump if in interstellar space after supposedly jumping to a system!
				if(worldScripts['nullgate'].logging) log(this.name," $ngHop ",$ngHop," $ngDestination ",$ngDestination," $ngMisjumpPercent ",$ngMisjumpPercent,$ngMisjumpPercent2);
			}
		}

		 if(worldScripts['nullgate'].logging) log(this.name,"Check 3: system.ID, $ngHop, $ngDestination, $ngMisjumpPercent, TargetSystem, Last Jump: ",system.ID,$ngHop, $ngDestination, $ngMisjumpPercent, player.ship.targetSystem, $ngJump_Array[$ngJump_Array.length-1],$ngPast," count: ",$ngCounter,$ngJump_Array.length,"Jump Path: ",$ngJump_Array);

		if(worldScripts['nullgate'].logging) log(this.name,$ngCounter,"Last check of next system.ID = ",$ngHop," vs ",$ngPast);

// Checks if misjump finder above somehow set it to <0.
		if($ngCounter < 0) $ngCounter = 0;

// Records previous location to later check for accidental misjumps.
		$ngPast = $ngHop;

//		this.$ng_jump($ngHop);
//		this.$ng_jump(0);
		this.$ng_jump();

	} else {

// This section means all jumps are DONE!

		// instead of reseting $ngCounter, use it as a basis of how many Thargoid groups to add to the system...that were "pulled along" in the jump-chain you just used.
		// Store in a mission variable every time the null gate is used by the player. For any jumps >1 (or impossible jumps or "random" jumps), increment the mission variable.
		// when the mission variable > random check, HUGE numbers of Thargoids appear in the system you exit at...
/*
		if(missionVariables.ngAttack != null && $ngJump_Array.length >3) {
			missionVariables.ngAttack = missionVariables.ngAttack + $ngJump_Array.length - 3;
		} else {
			missionVariables.ngAttack = missionVariables.ngAttack + $ngJump_Array.length - 3;
		}
*/
// For every jump past the 2nd, there is a cumulative 1% chance of triggering a Thargoid Swarm at your destination! Basically, they followed you or were "dragged along". (Fortunately resets with every Null Gate use.)
//		if( ($ngJump_Array.length -3) > Math.random()*100 && (player.score > 999 || missionVariables.$ng > 45)) {
		if(player.score > 999) {	// ALWAYS HAPPENS FOR TESTING!
//			system.addGroupToRoute("thargoid", 9, 0, "wp");
			system.addGroupToRoute("thargoid", Math.min(12,Math.ceil(2+Math.random()*Math.log(player.score+$ngJump_Array.length))), 0, "wp");
			if(worldScripts['nullgate'].logging) log(this.name,$ngJump_Array.length,"Thargoid swarm pulled through jump-chain!");
//			$ngAngry = 100;
//			this.$ngUnderAttack(); // added to trigger Thargoid swarms out of Null Gate!
//			this.shipBeingAttacked(); // added to trigger Thargoid swarms out of Null Gate!
		}
		$ngCounter = -9;
		$ngJump_Array = [-9];
//		player.commsMessage("Reached Jump Path destination! Computing travel time, please wait..."+player.ship.galaxyCoordinates,6);
		player.commsMessage("Reached Jump Path destination! Computing travel time, please wait...",6);
		if(this.$ngcheckTimer) this.$ngcheckTimer.start()
		else this.$ngcheckTimer = new Timer(this, this.$ngTime, 1, 1);
		if(system.ID > -1) this.$tryAddingNullgate();
	}
}

this.$ngTime = function()
{
// since the ngTime checks once a second, start a ~10 second countdown...only at the end of it, start adding Thargoid groups at the witchpoint that were 'dragged' along by the null gate jump path.
// flag mission briefing that this system has been attacked by a Thargoid invasion...but only after you leave for the next system?
// "You've been followed!" ...and Thargoid groups get added at the rate of 1 every 1-15 seconds after that.
	if(!clock.isAdjusting) {
//		player.commsMessage("Jumping took "+Math.ceil((clock.seconds - ngStartTime)/36)/100+" hours, ending at "+clock.clockString,6);
		player.commsMessage("Jumping took "+Number(((clock.seconds - ngStartTime)/3600).toFixed(2))+" hours, ending at "+clock.clockString,6);
		this.$ngcheckTimer.stop();
	}
}

this.$ng_jump = function()
{
	var $ngjumped = false;
	var $ngMisjumpPercent3 = Math.floor($ngHop/1000);
	var i = $ngHop - $ngMisjumpPercent3*1000;
//	var i = $ngHop - Math.floor($ngHop/1000)*1000;
	if(i > 699 && i <1000) i = i - 700;
	if(i > 299 && i <  600) i = 555 - i;
	if($ngCounter == null || $ngCounter <0) $ngCounter =0;	// $ngCounter = null/undefined catcher!
	if(worldScripts['nullgate'].logging) log(this.name,"Critical check! Jump count: "+$ngCounter+" jumping to: "+$ngHop+" or "+i+" misjump %: "+$ngMisjumpPercent3+" from: "+system.ID+" total Jump Path: "+$ngJump_Array);
// wormhole-making NPC ship
//	if(!swi0) {
//	swi0 = system.addShips("trader", 1, player.ship.position.add(player.ship.heading.multiply(300)), 0)[0]; // was distance 150, then 300, then 270 (for testing)
	var swi0 = system.addShips("alloy", 1, player.ship.position.add(player.ship.heading.multiply(160)), 0)[0]; // was distance 150, then 300, then 270 (for testing)
	swi0.fuel = 7;
	swi0.switchAI("missileAI.plist");
	swi0.AIState ="EXPLODE";
	if(worldScripts['nullgate'].logging) log(this.name,"Creating jumpship 'alloy'! "+swi0+"  Jump count: "+$ngCounter+" jumping to: "+$ngHop+" from: "+system.ID);
//	}
	if(i > -1 && i < 256 && i != system.ID) {	// Determines if next jump should be a random jump.
		var i_dist = Number(System.infoForSystem(galaxyNumber, system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,i)).toFixed(1));
//		player.commsMessage(this.name+" Jump count: "+$ngCounter+" jumping to: "+$ngHop+" or "+i+" distance: "+i_dist+" from: "+system.ID+" total Jump Path: "+$ngJump_Array);
		if(i_dist < 7 ) {
			if($ngMisjumpPercent3 == 0 || missionVariables.$ng < 70) {	// Determines if next jump should be a misjump. $ngHop == i ?
				player.commsMessage($ngCounter+".Jumping to system.ID = "+i+". system name "+System.systemNameForID(i),6);
//				player.commsMessage($ngCounter+".Jumping to system.ID = "+$ngHop+". system name "+System.systemNameForID($ngHop)+" at x,y: "+player.ship.galaxyCoordinates.x+" , "+player.ship.galaxyCoordinates.y,6);
			} else {
//				player.commsMessage($ngCounter+".Mis-jumping to: "+$ngHop,6);
				player.commsMessage($ngCounter+".Mis-jumping "+$ngMisjumpPercent3+"% to: "+i,6);
				if($ngMisjumpPercent3 >0 && $ngMisjumpPercent3 < 100) player.ship.scriptedMisjumpRange = $ngMisjumpPercent3/100;
				player.ship.scriptedMisjump = 1;
			}
			$ngjumped = swi0.exitSystem(i);
			if(worldScripts['nullgate'].logging) log(this.name,"inside check: Jump count: "+$ngCounter+" jumping to: "+$ngHop+" or "+i+" distance: "+i_dist+" from: "+system.ID+" total Jump Path: "+$ngJump_Array);
		} else $ngjumped = true; // the out-of-range jump which didn't happen was "successful" at not happening, otherwise I get an infinite loop on if(!$ngjumped) {
//		if(worldScripts['nullgate'].logging) player.commsMessage(" Jump count: "+$ngCounter+" jumping to: "+$ngHop+" or "+i+" distance: "+i_dist+" from: "+system.ID);
		if(worldScripts['nullgate'].logging) log(this.name,"outside check: Jump count: "+$ngCounter+" jumping to: "+$ngHop+" or "+i+" distance: "+i_dist+" from: "+system.ID+" total Jump Path: "+$ngJump_Array);
	} else $ngjumped = swi0.exitSystem();	// Jumps to random nearby system...hopefully!
// Eliminates errant alloys used to create wormholes.
	swi0.remove(true);
	if(!$ngjumped) {
		if(worldScripts['nullgate'].logging) log(this.name,"JUMP FAILED -- mass-locked? Moving ship and retrying!");
		player.ship.position = [-9E6*(1+Math.random()),-9E6*(1+Math.random()),-9E6*(1+Math.random())];
//		swi0.fuel = 7;
//		swi0.position = swi0.position.add(player.ship.heading.multiply(200));
		this.$ng_jump();
		return;
	}
//	} else if($ngCounter < 2) player.ship.position = player.ship.position.add(player.ship.heading.multiply(150)); // Can't avoid the wormhole this way, comment out for testing!

// Increases the Jump Counter.
	$ngCounter = $ngCounter + 1;
}

/*

this.$ng_jump = function($ng_jumping)
{
	var $ngjumped = false;
// wormhole-making NPC ship
//	if(!swi0) {
//		swi0 = system.addShips("trader", 1, player.ship.position.add(player.ship.heading.multiply(500)), 0)[0]; // was distance 150, then 130, then 300, then 270 (for testing)
		var swi0 = system.addShips("alloy", 1, player.ship.position.add(player.ship.heading.multiply(150)), 0)[0]; // was distance 150, then 130, then 300, then 270 (for testing)
		swi0.switchAI("missileAI.plist");
		swi0.AIState ="EXPLODE";
		if(worldScripts['nullgate'].logging) log(this.name,"Creating jumpship 'alloy'! "+swi0+"  Jump count: "+$ngCounter+" jumping to: "+$ngHop+" from: "+system.ID);
//	}
	swi0.fuel = 7;
	var i2 = parseInt($ngJump_Array[$ngCounter]);
	var $ngMisjumpPercent3 = Math.floor(i2/1000);
	var i = i2 - $ngMisjumpPercent3*1000;
//	var i = $ngHop - Math.floor($ngHop/1000)*1000;
	if(worldScripts['nullgate'].logging) log(this.name,"Critical check! Jump count: "+$ngCounter+" jumping to: "+$ngHop+" or "+i+" or "+i2+" misjump %: "+$ngMisjumpPercent3+" from: "+system.ID+" total Jump Path: "+$ngJump_Array);
	if(i > -1 && i < 256) {	// Determines if next jump should be a random jump.
		var i_dist = Number(System.infoForSystem(galaxyNumber, system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,i)).toFixed(1));
//		player.commsMessage(this.name+" Jump count: "+$ngCounter+" jumping to: "+$ngHop+" or "+i+" distance: "+i_dist+" from: "+system.ID+" total Jump Path: "+$ngJump_Array);
		if(i_dist < 7 ) {
			if($ngMisjumpPercent3 == 0) {	// Determines if next jump should be a misjump. $ngHop == i ?
				player.commsMessage($ngCounter+".Jumping to system.ID = "+$ngHop+" or "+i+". system name "+System.systemNameForID(i),6);
//				player.commsMessage($ngCounter+".Jumping to system.ID = "+$ngHop+". system name "+System.systemNameForID($ngHop)+" at x,y: "+player.ship.galaxyCoordinates.x+" , "+player.ship.galaxyCoordinates.y,6);
//				$ngjumped = swi0.exitSystem(i);
			} else {
//				player.commsMessage($ngCounter+".Mis-jumping to: "+$ngHop,6);
				player.commsMessage($ngCounter+".Mis-jumping "+$ngMisjumpPercent3+"% to: "+i,6);
				if($ngMisjumpPercent3 >0 && $ngMisjumpPercent3 < 100) player.ship.scriptedMisjumpRange = $ngMisjumpPercent3/100;
				player.ship.scriptedMisjump = 1;
//				$ngjumped = swi0.exitSystem(i);
			}
			$ngjumped = swi0.exitSystem(i);
			if(worldScripts['nullgate'].logging) log(this.name,"inside check: Jump count: "+$ngCounter+" jumping to: "+$ngHop+" or "+i+" distance: "+i_dist+" from: "+system.ID+" total Jump Path: "+$ngJump_Array);
		} else $ngjumped = true; // the out-of-range jump which didn't happen was "successful" at not happening, otherwise I get an infinite loop on if(!$ngjumped) {
//		if(worldScripts['nullgate'].logging) player.commsMessage(" Jump count: "+$ngCounter+" jumping to: "+$ngHop+" or "+i+" distance: "+i_dist+" from: "+system.ID);
		if(worldScripts['nullgate'].logging) log(this.name,"outside check: Jump count: "+$ngCounter+" jumping to: "+$ngHop+" or "+i+" distance: "+i_dist+" from: "+system.ID+" total Jump Path: "+$ngJump_Array);
	} else $ngjumped = swi0.exitSystem();
// Eliminates errant alloys used to create wormholes.
	swi0.remove(true);
	if(!$ngjumped) {
		if(worldScripts['nullgate'].logging) log(this.name,"JUMP FAILED -- mass-locked? Moving player ship and retrying!");
//		player.ship.position = [-1000000*(1+Math.random()), -1000000*(1+Math.random()),-1000000*(1+Math.random())];
		player.ship.position = [-99999999*(1+Math.random()), -99999999*(1+Math.random()),-99999999*(1+Math.random())];
//		swi0.fuel = 7;
//		swi0.position = swi0.position.add(player.ship.heading.multiply(200));
		this.$ng_jump(i);
	}
}

this.$ng_jump = function(ng_jump)
{
	var ngjumped = false;
	this.ngship1.fuel = 7;
	var i = $ngHop - Math.floor($ngHop/1000)*1000;
	if(i > -1 && i < 256) {
		var i_dist = Number(System.infoForSystem(galaxyNumber, system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,i)).toFixed(1));
//		player.commsMessage(this.name+" Jump count: "+$ngCounter+" jumping to: "+$ngHop+" or "+i+" distance: "+i_dist+" from: "+system.ID+" total Jump Path: "+$ngJump_Array);
		if(worldScripts['nullgate'].logging) player.commsMessage(" Jump count: "+$ngCounter+" jumping to: "+$ngHop+" or "+i+" distance: "+i_dist+" from: "+system.ID);
		if(worldScripts['nullgate'].logging) log(this.name,"Jump count: "+$ngCounter+" jumping to: "+$ngHop+" or "+i+" distance: "+i_dist+" from: "+system.ID+" total Jump Path: "+$ngJump_Array);
		if(i_dist < 7 ) ngjumped = this.ngship1.exitSystem(i)
		else ngjumped = true; // the out-of-range jump which didn't happen was "successful" at not happening, otherwise I get an infinite loop on if(!ngjumped) {
	} else ngjumped = this.ngship1.exitSystem();
	if(!ngjumped) {
		if(worldScripts['nullgate'].logging) log(this.name,"JUMP FAILED -- mass-locked? Moving player ship and retrying!");
		player.ship.position = [-1000000*(1+Math.random()), -1000000*(1+Math.random()),-1000000*(1+Math.random())];
		this.ngship1.position = this.ngship1.position.add(player.ship.heading.multiply(200));
		this.$ng_jump(i);
	}
}

this.defenderReady = function()
{
	if($ngDefendTimer && (clock.absoluteSeconds - $ngDefendTimer) > 30) {
		$ngDefendTimer = clock.absoluteSeconds;
		return true;
	} else {
		return false;
	}
}
*/

this.$hyperOut = function()
{
	if(worldScripts['nullgate'].logging) log(this.name,"Null Gate is badly damaged, bugging out!");
	if(system.ID != player.ship.targetSystem && System.infoForSystem(galaxyNumber,system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,player.ship.targetSystem)) < 7) $nullgate.exitSystem(player.ship.targetSystem);
	else $nullgate.exitSystem();
}

this.$checkNullgate = function()
{
	if($nullgate) if($nullgate.displayName == "Null Gate") $nullgate.sendAIMessage("GOODGATE");
	else $nullgate.sendAIMessage("EVILGATE");
}

//this.shipBeingAttacked = function (attacker)
this.$ngUnderAttack = function(attacker)
{
	if(!$ngAngry) $ngAngry = 0;
	if(worldScripts['nullgate'].logging) log(this.name,"Angry %: "+$ngAngry+" $ngTotalDefenders: "+$ngTotalDefenders+" $ngDefendTimer: "+$ngDefendTimer+" time difference: "+(clock.absoluteSeconds - $ngDefendTimer));
	$ngAngry++;

	if(!$ngTotalDefenders) $ngTotalDefenders = Math.log(player.score+1) ;	// was 15!
	if(!$ngDefendTimer) $ngDefendTimer = clock.absoluteSeconds;

	if(worldScripts['nullgate'].logging) player.commsMessage("Null Gate under attack! "+$ngAngry+" "+Math.floor(clock.absoluteSeconds - $ngDefendTimer),6);
	if($ngTotalDefenders > 0 && (clock.absoluteSeconds - $ngDefendTimer) > 5 && ($ngAngry+20) > Math.random()*100) { // was this.defenderReady()
		if(worldScripts['nullgate'].logging) log(this.name,"HULK getting angry! ",$ngAngry);

// Do something like this instead:
		$ngDefendTimer = clock.absoluteSeconds;
		$ngTotalDefenders--;
		// turn LIGHTS_ON !
//		nullgate.sendAIMessage("LIGHTS_ON");
		$nullgate.lightsActive = true;
//		this.ngThar_def = system.addShips("thargoid", 1, this.ship.position, 0)[0];
		this.ngThar_def = system.addShips("thargoid", 1, $nullgate.position, 0)[0];
		this.ngThar_def.orientation = $nullgate.orientation; // was = this.ship.orientation;
		this.ngThar_def.switchAI("exitNullGateAI.plist");
//		this.ngThar_def.velocity = this.ngThar_def.heading.multiply(200);
		if(worldScripts['nullgate'].logging) player.commsMessage("Null Gate launching Thargoid defenders! "+$ngTotalDefenders,6);
		if($ngAngry > Math.random()*100) { // this.$ngInvasion();
			if(worldScripts['nullgate'].logging) log(this.name,"1 HULK SMASH! ",$ngAngry,Math.floor(clock.absoluteSeconds - $ngDefendTimer));
			if(this.$ngcheckTimer2) this.$ngcheckTimer2.start()
			else this.$ngcheckTimer2 = new Timer(this, this.$ngInvasion, 5, 5);
		}
	} else if($ngAngry < 99) $nullgate.lightsActive = false;
//	} else if($ngAngry < 99) nullgate.sendAIMessage("LIGHTS_OFF");
}

this.$ngInvasion = function()
{
	if(worldScripts['nullgate'].logging) player.commsMessage("HULK SMASH! "+$ngAngry+" "+Math.floor(clock.absoluteSeconds - $ngDefendTimer),6);
	if(worldScripts['nullgate'].logging) log(this.name,"HULK SMASH! ",$ngAngry,Math.floor(clock.absoluteSeconds - $ngDefendTimer));
	$ngAngry = 100;
	// turn LIGHTS_ON !
//	nullgate.sendAIMessage("LIGHTS_ON");
	$nullgate.lightsActive = true;
	if($ngTotalDefenders > 0) {
		if((clock.absoluteSeconds - $ngDefendTimer) > 5) { // was this.defenderReady()
			$ngDefendTimer = clock.absoluteSeconds;
			$ngTotalDefenders--;
//			this.ngThar_def = system.addShips("thargoid", 1, this.ship.position, 0)[0];
			this.ngThar_def = system.addShips("thargoid", 1, $nullgate.position, 0)[0];
//			this.ngThar_def.orientation = this.ship.orientation;
			this.ngThar_def.orientation = $nullgate.orientation;
			this.ngThar_def.switchAI("exitNullGateAI.plist");
			if(worldScripts['nullgate'].logging) player.commsMessage("Null Gate launching Thargoid defenders! "+$ngTotalDefenders,6);
		}
	} else {
		$ngAngry = 0;
		this.$ngcheckTimer2.stop();
	}
}

this.$npcTraders = function()
{
	if($ngTotalDefenders < 10) $ngTotalDefenders += 1; // SLOWLY replaces lost/used defenders!

	var ngOutTraders = system.filteredEntities(this, nullgates_outboundNPCs); // list of outbound traders
	var ngInTraders = system.filteredEntities(this, nullgates_inboundNPCs); // list of inbound traders
	var nullgates = system.shipsWithRole("nullgate");

	if(ngInTraders.length > 0) {
		for(var ngi = 0; ngi < ngInTraders.length; ngi++)
		{
			if(Math.random() < 0.2 && nullgates.length > 0) {
				ngInTraders[ngi].target = nullgates[0];
				ngInTraders[ngi].script.checkGateDistance = this.checkGateDistance;
				ngInTraders[ngi].setAI("NullGate_useGateAI.plist");
			}
		}
	}

	if(ngOutTraders.length > 0) {
		for(var ngi = 0; ngi < ngOutTraders.length; ngi++)
		{
			if(Math.random() < 0.2 && nullgates.length > 0) {
				ngOutTraders[ngi].target = nullgates[0];
				ngOutTraders[ngi].script.checkGateDistance = this.checkGateDistance;
				ngOutTraders[ngi].setAI("NullGate_useGateAI.plist");
			}
		}
	}
}

// The function below is assigned to NPC ships using the jump nullgates
/*
this.checkGateDistance = function()
{
	if(this.ship.position.distanceTo(this.ship.target.position) > 51200) this.ship.reactToAIMessage("NEXT_GATE");
}
*/

// this function is potentially called multiple times.
this.missionScreenOpportunity = function ()
{
	if(worldScripts['nullgate'].logging) log(this.name,"NullGate mission variables check ",missionVariables.$ng,this.nullgateJustran,this.firstLaunch,guiScreen,galaxyNumber,system.ID,system.techLevel);
//	this.nullgateJustran = 0;
	if(player.ship.dockedStation.isMainStation && guiScreen != "GUI_SCREEN_MISSION" && !this.nullgateJustran) if(system.countShipsWithRole("thargoid") >3) {
		mission.runScreen({titleKey: "generic_thargoid_title", messageKey: "nullgate_warning", model: "thargoid"});	// Generic Thargoid system invasion WARNING.
		this.ngSound = new SoundSource;
		this.ngSound.sound = "warning.ogg";
		this.ngSound.loop = false;
		this.ngSound.play();
		this.nullgateJustran = 1;
	} else if(galaxyNumber == 2) {
		if(worldScripts['nullgate'].logging) log(this.name,"...should show NullGate mission briefing now. ",missionVariables.$ng);
//		if(!missionVariables.$ng && (system.techLevel >8 || (galaxyNumber != 2 && system.techLevel >12))) {
//		if((missionVariables.$ng <1 || !missionVariables.$ng) && (system.techLevel >11 || (galaxyNumber == 2 && system.techLevel >8))) {
		if(missionVariables.$ng == null) missionVariables.$ng = 0;
		if(missionVariables.$ng <1 && system.techLevel >8 && system.government > 2) {	// NEED a pre-announce not telling specifics, like seen in other Galaxy Charts besides the 3rd!
// FIRST time running Null Gate mission = Introduction to Null Gates! (REQUIRED to get later NG missions!)
			if(player.score > 1999 || missionVariables.thargplans == "MISSION_COMPLETE") mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_briefb", model: "nullgate"})
			else mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief", model: "nullgate2"});
			missionVariables.$ng = 1;
			this.nullgateJustran = 1;
		} else {
			var x = parseInt(missionVariables.$ng);
			var x10 = Math.floor(x/10)*10;
			var x100 = Math.floor(x/100)*100;
			var x1000 = Math.floor(x/1000)*1000;
			var s = system.ID; // No sense calling system.ID every time when I can just store the value in a variable.
//	(missionVariables.$ng - Math.floor(missionVariables.$ng/10)*10) <2 <- does a "decimal bit mask", which removes all the parts 10 and up, leaving a number from 0-9. Since I'm only checking to see if the value is 1-9, <2 works and ignores the ones digit.
//		if(player.score > 99 && (missionVariables.$ng - Math.floor(missionVariables.$ng/10)*10) <2) {
		if(player.score > 99 && (x - x10) <2 && system.techLevel >10 && Math.random() < 0.2) { // system.countShipsWithRole("nullgate") >0
// TL >11 (so only at TL 12-15!) means no derelict Null Gates will be counted. Any High-Tech centers would know about Teedus' NG being back online.
// Problem (solved?) with Null Gate at Teedus! (2nd intro to Null Gates, REQUIRED to get any NG missions... as it "sets the stage" for known problems with NGs.)
// "The massive Null Space Warp Gate at what was historically the Lobstoid Empire's secondary capital of Teedus in Galaxy Chart 3 has been officially reactivated after it has been offline for an unknown number of years."
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief1", model: "nullgate"});
			x += 1;
			this.nullgateJustran = 1;
//			mission.markSystem(54);
		} else {
// Currently not catching the condition that brief 0-2 hasn't been shown yet! :(

		if(player.score > 150 && system.countShipsWithRole("nullgate") >0 && system.techLevel >9 && system.government >4 && Math.random() < 0.1 && (x - x10) >1 && (x - x10) <3 ) {
//		if(player.score > 200 && system.countShipsWithRole("nullgate") >0 && s != 54 && system.techLevel >9 && (x - x1000) >50 && (x - x1000) <60 ) {
// Rumors? Travel Advisory?	"Reports are on the rise that escort ships of freighters passing through the Null Gates are disappearing."
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief14", model: "escort"}); // was model: "nullgate"});	or "escort-medium"
			x += 1;
			this.nullgateJustran = 1;
		} else if(player.score > 200 && ((system.countShipsWithRole("nullgate") <1 && system.government >4) || (s == 42 || s == 54)) && Math.random() < 0.2 && (x - x10) >2 && (x - x10) <4 ) {
// Missing freighter escorts are turning up in nearby systems after they passed through Null Gates.
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief15", model: "escort"}); // was model: "nullgate"});	or "escort-medium"
			x += 1;
			this.nullgateJustran = 1;
		} else if(player.score > 250 && system.countShipsWithRole("nullgate") >0 && system.techLevel >8 && system.government >4 && Math.random() < 0.1 && (x - x10) >3 && (x - x10) <5 ) {
// A few freighters with escorts have passed through the Null Gates only to have some or all of their escorts vanish!
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief16", model: "escort"}); // was model: "nullgate"});	or "escort-medium"
			x += 1;
			this.nullgateJustran = 1;
		} else if(player.score > 300 && system.countShipsWithRole("nullgate") >0 && system.government >4 && (x - x10) >4 && (x - x10) <6 ) {
// Travel Advisory:	Do not use Null Gates unless your ship has hyperspace ability and a full fuel tank!
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief20", model: "nullgate"}); // was model: "nullgate"});
			x += 1;
			this.nullgateJustran = 1;
		} else if(player.score > 350 && system.countShipsWithRole("nullgate") >0 && system.techLevel >9 && system.government >4 && Math.random() < 0.1 && (x - x10) >5 && (x - x10) <7 ) {
// A handful of freighter escorts still remain missing months after being last seen entering a Null Gate.
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief17", model: "escort"}); // was model: "nullgate"});	or "escort-medium"
			x += 1;
			this.nullgateJustran = 1;
		} else if(player.score > 700 && (((s == 93 || s == 121 || s == 161 || s == 185) && Math.random() < 0.1) || (s == 118 && Math.random() < 0.25)) && (x - x10) >6 && (x - x10) <8) {
//		if(player.score > 255 && (system.ID == 185 || system.ID == 118 || system.ID == 93) && (missionVariables.$ng - Math.floor(missionVariables.$ng/10)*10) <4) {
//		if(galaxyNumber == 2 && player.score > 255 && system.ID == 118 && missionVariables.$ng) {
// THIS needs to not occur till AFTER both NG announcements above...AND possibly the Anaconda disappears?
// Derelict Null Gate spotted at system number 118 Uszale!
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief2", model: "nullgate2"}); // was model: "nullgate"});
			x += 1;
			mission.markSystem(118);
			this.nullgateJustran = 1;
		} else if(player.score > 750 && (s == 54 || s == 93 || s == 118 || s == 121 || s == 161 || s == 169 || s == 183 || s == 185 || s == 190) && system.countShipsWithRole("thargoid") >0 && (x - x10) >7 && (x - x10) !=9) {
//		if(player.score > 500 && (s == 185 || s == 118 || s == 93) && (x - x100) >70 && (x - x1000) <100) {
// Null Gate somehow related to Thargoid attacks?	"Thargoid attacks have been reported on the rise in-and-around Istimale."
// Do this after the asteroid miner finds the derelict Null Gate! AND after Null Gate at Teedus causes an Anaconda to disappear!
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief5", model: "thargoid"}); // was model: "nullgate"});
			x += 1;
			this.nullgateJustran = 1;
//			mission.markSystem(42,54,70,118,159,170,181,182,235,246,255, 5,17,34,69,79,81,145,155,219, 26,129,193, 10,38,58,116, 6,22,36,63, 43,107,132,149,213,223);
//		} else if(player.score > 255 && (s == 54 || s == 129) && (x - x100) <10) {
//		} else if(player.score > 400 && (s == 54 || s == 93 || s == 118 || s == 121 || s == 161 || s == 185) && Math.random() < 0.2 && (x - x10) >5 && (x - x100) <10) {
		} else if(player.score > 400 && (((s == 54 || s == 93 || s == 118 || s == 121 || s == 161 || s == 185) && Math.random() < 0.2) || ((s == 36 || s == 38 || s == 42 || s == 79 || s == 129 || s == 169 || s == 183 || s == 190) && Math.random() < 0.05)) && (x - x10) >5 && (x - x100) <10) {
// Null Gate at 54.Teedus causes an Anaconda to disappear?
// Has to happen *AFTER* the NG at Teedus is "back online"!
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief3", model: "anaconda"});
			x += 10;
			mission.markSystem(54);
			this.nullgateJustran = 1;
		} else if(player.score > 450 && system.countShipsWithRole("nullgate") >0 && system.techLevel >9 && system.government >4 && Math.random() < 0.2 && (x - x100) >10 && (x - x100) <20 ) {
// Out of the many escorts that went missing but were later found, none reported being dropped off in interstellar space by a Null Gate and being forced to manually hyperspace out.
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief17b", model: "thargoid"});
			x += 10;
			this.nullgateJustran = 1;
		} else if(player.score > 480 && system.techLevel >9 && system.government >4 && Math.random() < 0.2 && (x - x100) >20 && (x - x100) <30) {
// Null Gate at Teedus causes an Anaconda to disappear? ...part 1.5!
// This is the Null Gate Researcher's comments on the missing Anaconda!
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief3c", model: "anaconda"}); //	model: "anaconda_redux.dat"  <- CAN'T USE, since model is called by ROLE not ship name!
			x += 10;
			this.nullgateJustran = 1;
		} else if(player.score > 500 && (s == 224 || s == 162 || s == 129 || s == 126 || s == 63 || s == 61 || s == 51 || s == 42 || s == 40 || s == 36 || s == 35 || (s == 183 && Math.random() < 0.2) || (s == 54 && Math.random() < 0.1)) && (x - x100) >30 && (x - x100) <40) {
//		if(galaxyNumber == 2 && player.score > 255 && (system.ID == 54 || system.ID == 129) && (missionVariables.$ng == "STAGE_0" || missionVariables.$ng == "STAGE_1")) {
// Null Gate at Teedus causes an Anaconda to disappear? ...part 2! It reappeared at 40.Ersodi many light-years away from its scheduled route!
// Has to happen *AFTER* the NG at 54.Teedus is "back online"! ...and after the Anaconda first goes missing! (DUH!)
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief3b", model: "anaconda"}); //	model: "anaconda_redux.dat"  <- CAN'T USE, since model is called by ROLE not ship name!
			x += 10;
			mission.unmarkSystem(54);
//			mission.markSystem(58,116);
			this.nullgateJustran = 1;
		} else if(player.score > 840 && system.countShipsWithRole("nullgate") >0 && system.techLevel >9 && system.government >4 && (system.countShipsWithRole("thargoid") >0 || Math.random() < 0.1) && (x - x100) >40 && (x - x100) <50 ) {
// Null Gate somehow related to Thargoid attacks? ...part 2?	"Thargoid swarm has been reported at Raerqu (ID=182)."
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief6", model: "thargoid"}); // was model: "nullgate"});
			x += 10;
			mission.markSystem(182);
			mission.unmarkSystem(118);
			this.nullgateJustran = 1;
		} else if(player.score > 850 && (s == 34 || s == 38 || s == 42 || s == 51 || s == 69 || s == 79 || s == 155 || s == 182) && (x - x100) >50 && (x - x100) <60 ) {
// Sometime after Thargoid swarm reported at Raerqu (ID=182), Ed's Mooned Fitsgrald (Boa) goes missing around that area.
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief7", model: "boa"}); // was model: "nullgate"});
			x += 10;
			mission.markSystem(182);
			this.nullgateJustran = 1;
		} else if(player.score > 899 && (s == 34 || s == 38 || s == 79 || s == 154 || s == 182 || (system.techLevel >11 && Math.random() < 0.2)) && (x - x100) >60 && (x - x100) <70 ) {
// Shortly afterwards, damaged but empty escape pod found...probably from Ed's Mooned Fitsgrald (Boa).
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief7b", model: "escape-capsule"}); // was model: "nullgate"}); later was "boa" But the escape pod makes more painful sense.
			x += 10;
			mission.unmarkSystem(182);
			this.nullgateJustran = 1;
		} else if(player.score > 950 && system.countShipsWithRole("nullgate") >0 && system.techLevel >8 && system.government >4 && Math.random() < 0.2 && (x - x100) >70 && (x - x100) <80 ) {
// Gal. Navy's preliminary findings are that both freighters ended up misplaced or lost as a result of pilot error:
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief9", model: "anaconda"});
			x += 10;
			this.nullgateJustran = 1;
		} else if(player.score > 980 && system.countShipsWithRole("nullgate") >0 && system.techLevel >8 && system.government >4 && Math.random() < 0.3 && (x - x100) >80 && (x - x100) <90 ) {
// Ignore the official news on the Exion Valdiaz Anaconda's captain being blamed for its 'temporary' disappearance -- Gal. Navy is about to do something BIG!
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief9b", model: "anaconda"});
			x += 10;
			this.nullgateJustran = 1;
		} else if((player.score > 999 || missionVariables.conhunt == "MISSION_COMPLETE") && (s == 42 || s == 54) && (x - x10) >5 && (x - x1000) <100 ) {
//		} else if(player.score > 999 && missionVariables.conhunt == "MISSION_COMPLETE" && system.countShipsWithRole("nullgate") >0 && (s == 42 || s == 54) && (x - x10) >5 && (x - x1000) <100 ) {
// [Lobstoid Apocalyptic Log...] part 1.
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief13", model: "nullgate"});
			x += 100;
		} else if((s == 42 || s == 54) && (x - x1000) >105 && (x - x1000) <200 ) {
// [Lobstoid Apocalyptic Log...] part 2.
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief13b", model: "nullgate"});
			x += 100;
		} else if((s == 42 || s == 54) && (x - x1000) >205 && (x - x1000) <300 ) {
// [Lobstoid Apocalyptic Log...] part 3.
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief13c", model: "thargoid"});
			x += 100;
		} else if((s == 42 || s == 54) && (x - x1000) >305 && (x - x1000) <400 ) {
// [Lobstoid Apocalyptic Log...] part 4.
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief13d", model: "nullgate2"});
			x += 100;
			this.nullgateJustran = 1;
		} else if((player.score > 1499 || missionVariables.conhunt === "MISSION_COMPLETE") && system.techLevel >9 && system.government >4 && (x - x1000) >406 && (x - x1000) <500 ) {
// I'd like to offer you another job for the Galactic Navy ...for which you will be well-paid...
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief26e", model: "nullgate2"});
			x += 100;
		} else if((player.score > 1499 || missionVariables.conhunt === "MISSION_COMPLETE") && system.techLevel >9 && system.government >4 && (x - x1000) >506 && (x - x1000) <600 ) {
// Researcher only gives out this info if you've done the Constrictor mission:
// A classified Galactic Navy debate happened decades ago concerning the ancient warp gates discovered in numerous systems...
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief31", model: "nullgate"});
			x += 100;
		} else if((player.score > 1499 || missionVariables.conhunt === "MISSION_COMPLETE") && system.techLevel >9 && system.government >4 && (x - x1000) >606 && (x - x1000) <700 ) {
// ...Shipping companies may eventually figure out a use for them, but the Galactic Navy likely will not.
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief31b", model: "nullgate"});
			x += 100;
		} else if((player.score > 1499 || missionVariables.conhunt === "MISSION_COMPLETE") && system.techLevel >9 && system.government >4 && (x - x1000) >706 && (x - x1000) <800 ) {
// ...Warp gates are not 'doors' and cannot open or close off any jump routes at all.
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief31c", model: "nullgate2"});
			x += 100;
		} else if((player.score > 1499 || missionVariables.conhunt === "MISSION_COMPLETE") && system.techLevel >9 && system.government >4 && (x - x1000) >806 && (x - x1000) <900 ) {
// Despite Null Gates extreme shortcomings, shipping companies are already using them.
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief33", model: "nullgate"});
			x += 100;
			this.nullgateJustran = 1;
		} else if((player.score > 1799 || missionVariables.conhunt === "MISSION_COMPLETE") && system.techLevel >9 && system.government >4 && Math.random() < 0.3 && x >907 && x <1000 ) {
// Researcher mentions he will pay for the discovery of more Derelict Null Gates.
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief30", model: "nullgate2"});
			x += 1000;
			this.nullgateJustran = 1;
		} else if((player.score > 1999 || missionVariables.conhunt === "MISSION_COMPLETE") && system.techLevel >11 && system.government >4 && x >1947 && x <2000 ) {
// "I've contacted numerous shipping companies and requesting logs of Null Gate use..."
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief36", model: "anaconda"});
			x += 1000;
			this.nullgateJustran = 1;
		} else if((player.score > 2499 || missionVariables.conhunt === "MISSION_COMPLETE") && system.techLevel >11 && system.government >4 && Math.random() < 0.3 && x >2947 && x <3000 ) {
// The Galactic Navy is continuing their investigations...
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief38", model: "nullgate"});
			x += 1000;
			this.nullgateJustran = 1;
		} else if((player.score > 2999 || missionVariables.conhunt === "MISSION_COMPLETE") && system.techLevel >11 && system.government >4 && Math.random() < 0.2 && x >3948 && x <4000 ) {
// "'I finally got some replies back from various shipping companies"
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief37", model: "escort"});	// was 	or "escort-medium"
			x += 1000;
			this.nullgateJustran = 1;
/*
		} else if((player.score > 3099 || missionVariables.conhunt === "MISSION_COMPLETE") && system.techLevel >11 && system.government >4 && Math.random() < 0.25 && x >4948 && x <5000 ) {
// "I mentioned before that there seems to be a minor correlation between vanished escorts and ship types."
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief37b", model: "escort"});	// was 	or "escort-medium"
			x += 1000;
			this.nullgateJustran = 1;
*/
		} else if((player.score > 3499 || missionVariables.thargplans == "MISSION_COMPLETE") && system.techLevel >11 && system.government >4 && x >4948 && x <5000 ) {
// A couple more theories are being thrown around as to the cause of the missing escorts...ALL scary as HELL!
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief39", model: "escort"});	// was 	or "escort-medium"
			x += 1000;
			this.nullgateJustran = 1;
		} else if((player.score > 3999 || missionVariables.thargplans == "MISSION_COMPLETE") && system.techLevel >11 && system.government >4 && Math.random() < 0.3 && x >5958 && x <6000 ) {
// Those Jump Gates are really jumpin'!
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief22", model: "nullgate"});
			x += 1000;
			this.nullgateJustran = 1;
		} else if((player.score > 4499 || missionVariables.thargplans == "MISSION_COMPLETE") && system.techLevel >11 && system.government >4 && x >6958 && x <7000 ) {
// How did a lot of Null Gates get stuck at one system?
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief35", model: "nullgate2"});
			x += 1000;
			this.nullgateJustran = 1;
		} else if((((player.score > 4999 || (missionVariables.thargplans == "MISSION_COMPLETE" && missionVariables.cloak == "COMPLETE")) && system.techLevel >11 && system.government >4 && Math.random() < 0.1) || system.ID ==133) && x >7978 && x <8000 ) {
// Over the last year, a lot of very confused escort ships have arrived at Ditere...
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief48", model: "escort"});	// was 	or "escort-medium"
			x += 1000;
			this.nullgateJustran = 1;
		} else if((player.score > 5499 || (missionVariables.thargplans == "MISSION_COMPLETE" && missionVariables.cloak == "COMPLETE")) && system.countShipsWithRole("nullgate") >0 && system.government >4 && Math.random() < 0.2 && x >7978 && x <10000 ) {
// Null Gates aren't habitable or dockable stations...
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief23", model: "nullgate2"});
//			x += 1000;
			this.nullgateJustran = 1;
		} else if((player.score > 5999 || (missionVariables.thargplans == "MISSION_COMPLETE" && missionVariables.cloak == "COMPLETE")) && system.techLevel >11 && system.government >4 && Math.random() < 0.2 && x >8988 && x <9000 ) {
// Galactic Navy official report regarding the lost escorts!
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief50", model: "nullgate"});
			x += 1000;
			this.nullgateJustran = 1;
		} else if(player.score > 400 && system.countShipsWithRole("nullgate") >0 && system.techLevel >5 && system.government >4 && Math.random() < 0.2 && (x - x100) >10 ) {
//		} else if(player.score > 2500 && system.countShipsWithRole("nullgate") >0 && system.techLevel >8 && system.government >4 && Math.random() < 0.1 && (x - x100) >96) {
// Travel Advisory Update:	Do not use Null Gates unless your ship has hyperspace ability and a full fuel tank! AND a Galactic Hyperdrive!!!
			if(missionVariables.nova == "NOVA_HERO" || missionVariables.nova == "NOVA_ESCAPE_COWARD") mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief21", model: "nullgate"})
			else mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief20", model: "nullgate"});
//			x += 10;
			this.nullgateJustran = 1;
		}
// BAD things happen at system 213 next?
// Just a bullshit extra for future expansion...
// Player's own discoveries that Null Gates can dump you off in "unexpected"/off-course/off-target can create additional mission briefings.
		}
			if(worldScripts['nullgate'].logging) log(this.name,"missionVariables.$ng before and after ",missionVariables.$ng,x);
			if(parseInt(missionVariables.$ng) != parseInt(x)) missionVariables.$ng = parseInt(x);	// Only do this if there's been a change.
		}
//	this.nullgateJustran = 1;
//	this.nullgateJustran++;
// Higher-tech Lobstoid systems will know the basic history of the Lobstoid Empire...
	} else if(missionVariables.$ng <1 && ((galaxyNumber == 0 && (system.ID == 19 || system.ID == 58 || system.ID ==159 || system.ID ==182 || system.ID ==207 || system.ID ==211 || system.ID ==237)) || 
(galaxyNumber == 1 && (system.ID == 15 || system.ID == 46 || system.ID == 85 || system.ID == 87 || system.ID == 90 || system.ID ==125 || system.ID ==136 || system.ID ==138 || system.ID ==158 || system.ID ==168 || system.ID ==183 || system.ID ==216 || system.ID ==248)) || 
(galaxyNumber == 3 && (system.ID == 57 || system.ID == 64 || system.ID ==126 || system.ID ==136 || system.ID ==190 || system.ID ==238 || system.ID ==254)) || 
(galaxyNumber == 4 && (system.ID == 11 || system.ID == 92 || system.ID == 98 || system.ID ==106 || system.ID ==143 || system.ID ==190 || system.ID ==203 || system.ID ==211 || system.ID ==238 || system.ID ==254)) || 
(galaxyNumber == 5 && (system.ID == 21 || system.ID == 86 || system.ID ==134 || system.ID ==156 || system.ID ==178 || system.ID ==212 || system.ID ==226 || system.ID ==255)) || 
(galaxyNumber == 6 && (system.ID == 2 || system.ID == 6 || system.ID == 57 || system.ID == 74 || system.ID == 88 || system.ID == 89 || system.ID ==135 || system.ID ==163 || system.ID ==224 || system.ID ==230 || system.ID ==247)) || 
(galaxyNumber == 7 && (system.ID == 33 || system.ID == 39 || system.ID == 40 || system.ID == 41 || system.ID == 42 || system.ID == 44 || system.ID == 59 || system.ID == 82 || system.ID == 85 || system.ID == 93 || system.ID ==115 || system.ID ==122 || system.ID ==153 || system.ID ==155 || system.ID ==183 || system.ID ==212 || system.ID ==229 || system.ID ==244)))
&& player.score > 50) {
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief", model: "nullgate2"});
			missionVariables.$ng = 1;
			this.nullgateJustran = 1;
// Xeer in Galaxy Chart 0 DOESN'T KNOW the basic history of the Lobstoid Empire...
	} else if(missionVariables.$ng <1 && (galaxyNumber == 0 && system.ID ==150) && (missionVariables.conhunt == "MISSION_COMPLETE" || Math.random() < 0.2) && player.score > 50) {
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief25", model: "coriolis"});
//			missionVariables.$ng = 1;
			this.nullgateJustran = 1;
// Lave in Galaxy Chart 0 or TL 14-15 main stations might know the basic history of the Lobstoid Empire...
	} else if(missionVariables.$ng <1 && ((galaxyNumber == 0 && system.ID == 7 && (missionVariables.conhunt == "MISSION_COMPLETE" || Math.random() < 0.3)) || (system.techLevel > 12 && system.government > 4 && Math.random() < 0.1)) && player.score > 50) {
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief24", model: "nullgate2"});
//			missionVariables.$ng = 1;
			this.nullgateJustran = 1;
// PRE-Introduction to Null Gates! (Given in Galaxy Charts other than 3 at "safer" TL 12-15 main stations.) ...needs to only be shown ONCE per Galaxy Chart!
	} else if(((missionVariables.$ng < 1 && missionVariables.$ng != -1) || missionVariables.$ng == null) && system.techLevel > 10 && system.government > 4) {
//		if(player.score > 1999 || missionVariables.thargplans == "MISSION_COMPLETE") mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief", model: "nullgate2"})
//		else mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief", model: "nullgate2"});
// Ancient and mysterious inactive jump gates have been discovered in star systems throughout inhabited space.
		mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief0", model: "nullgate2"});
		missionVariables.$ng = -1;
		this.nullgateJustran = 1;
// Latest Thargoid attack killed billions!
	} else if(missionVariables.$ng >92 && galaxyNumber == 4 && system.countShipsWithRole("nullgate") >0 && system.countShipsWithRole("thargoid") >3 && player.score > 9999) {
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief19", model: "thargoid"});
//			missionVariables.$ng = 1;
			this.nullgateJustran = 1;
		} else if((player.score > 4999 || (missionVariables.thargplans == "MISSION_COMPLETE" && missionVariables.cloak == "COMPLETE")) && system.techLevel >11 && galaxyNumber > 2 && system.government >4 && Math.random() < 0.1 && missionVariables.$ng >7978 && missionVariables.$ng <8000 ) {
// Over the last year, a lot of very confused escort ships have arrived at Ditere...
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief48", model: "escort"});	// was 	or "escort-medium"
			missionVariables.$ng += 1000;
			this.nullgateJustran = 1;
		} else if((player.score > 5999 || (missionVariables.thargplans == "MISSION_COMPLETE" && missionVariables.cloak == "COMPLETE")) && system.techLevel >11 && galaxyNumber > 2 && system.government >4 && Math.random() < 0.2 && missionVariables.$ng >8988 && missionVariables.$ng <9000 ) {
// Galactic Navy official report regarding the lost escorts!
			mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief50", model: "nullgate"});
			missionVariables.$ng += 1000;
			this.nullgateJustran = 1;
	} else if(player.score > 3000 && system.countShipsWithRole("nullgate") >0 && system.techLevel >9 && system.government >4 && Math.random() < 0.1 && missionVariables.$ng >6) {
// Travel Advisory Update:	Do not use Null Gates unless your ship has hyperspace ability and a full fuel tank! AND a Galactic Hyperdrive!!!
			if(missionVariables.nova == "NOVA_HERO" || missionVariables.nova == "NOVA_ESCAPE_COWARD") mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief21", model: "nullgate"})
			else mission.runScreen({titleKey: "nullgate_title", messageKey: "nullgate_brief20", model: "nullgate"});
//			x += 10;
			this.nullgateJustran = 1;
	}
};
/*
Variables used:
	this.firstLaunch
	$ngDefendTimer
	$ngHop
	$ngPast
	$ngPastClients
	$ngTotalDefenders
	ngship
	ngInTraders
	ngi
	ngOutTraders
	ngStartTime
	ng_waitingline
	nullgate
	var nullgates
	missionVariables.$ng
	this.nullgateJustran
	this.ngship1
	this.ngThar_def
	this.ship?
	var x , x10 , x100 , x1000 , s , i - temp variables
*/